<?php

/**
 * ======================================================================
 * LICENSE: This file is subject to the terms and conditions defined in *
 * file 'license.txt', which is part of this source code package.       *
 * ======================================================================
 */

/**
 * Backend Utility manager
 * 
 * @package AAM
 * @author Vasyl Martyniuk <vasyl@vasyltech.com>
 */
class AAM_Backend_Feature_Settings_Manager  extends AAM_Backend_Feature_Abstract {
    
    /**
     * Save AAM utility options
     * 
     * @return string
     *
     * @access public
     */
    public function save() {
        $param = AAM_Core_Request::post('param');
        $value = stripslashes(AAM_Core_Request::post('value'));
        
        AAM_Core_Config::set($param, $value);
        
        return json_encode(array('status' => 'success'));
    }
    
    /**
     * Delete AAM utility options
     * 
     * @return string
     *
     * @access public
     */
    public function delete() {
        $param = AAM_Core_Request::post('param');
        
        AAM_Core_Config::delete($param);
        
        return json_encode(array('status' => 'success'));
    }
    
}