/** 
 * ATUM Inventory Management for WooCommerce CSS 
 * @version 1.4.13 
 * @author Be Rebel  
 *
 * Author URI: https://berebel.io 
 * License : Copyright 2018 Stock Management Labs 
 */

 @charset "UTF-8";
.select2-container {
  box-sizing: border-box;
  display: inline-block;
  margin: 0;
  position: relative;
  vertical-align: middle;
}

.select2-container .select2-selection--single {
  box-sizing: border-box;
  cursor: pointer;
  display: block;
  height: 28px;
  user-select: none;
  -webkit-user-select: none;
}

.select2-container .select2-selection--single .select2-selection__rendered {
  display: block;
  padding-left: 8px;
  padding-right: 20px;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
}

.select2-container .select2-selection--single .select2-selection__clear {
  position: relative;
}

.select2-container[dir="rtl"] .select2-selection--single .select2-selection__rendered {
  padding-right: 8px;
  padding-left: 20px;
}

.select2-container .select2-selection--multiple {
  box-sizing: border-box;
  cursor: pointer;
  display: block;
  min-height: 32px;
  user-select: none;
  -webkit-user-select: none;
}

.select2-container .select2-selection--multiple .select2-selection__rendered {
  display: inline-block;
  overflow: hidden;
  padding-left: 8px;
  text-overflow: ellipsis;
  white-space: nowrap;
}

.select2-container .select2-search--inline {
  float: left;
}

.select2-container .select2-search--inline .select2-search__field {
  box-sizing: border-box;
  border: none;
  font-size: 100%;
  margin-top: 5px;
  padding: 0;
}

.select2-container .select2-search--inline .select2-search__field::-webkit-search-cancel-button {
  -webkit-appearance: none;
}

.select2-dropdown {
  background-color: #fff;
  border: 1px solid #adb5bd;
  border-radius: 4px;
  box-sizing: border-box;
  display: block;
  position: absolute;
  left: -100000px;
  width: 100%;
  z-index: 1051;
}

.select2-results {
  display: block;
}

.select2-results__options {
  list-style: none;
  margin: 0;
  padding: 0;
}

.select2-results__option {
  padding: 6px;
  user-select: none;
  -webkit-user-select: none;
}

.select2-results__option[aria-selected] {
  cursor: pointer;
}

.select2-container--open .select2-dropdown {
  left: 0;
}

.select2-container--open .select2-dropdown--above {
  border-bottom: none;
  border-bottom-left-radius: 0;
  border-bottom-right-radius: 0;
}

.select2-container--open .select2-dropdown--below {
  border-top: none;
  border-top-left-radius: 0;
  border-top-right-radius: 0;
}

.select2-search--dropdown {
  display: block;
  padding: 4px;
}

.select2-search--dropdown .select2-search__field {
  padding: 4px;
  width: 100%;
  box-sizing: border-box;
}

.select2-search--dropdown .select2-search__field::-webkit-search-cancel-button {
  -webkit-appearance: none;
}

.select2-search--dropdown.select2-search--hide {
  display: none;
}

.select2-close-mask {
  border: 0;
  margin: 0;
  padding: 0;
  display: block;
  position: fixed;
  left: 0;
  top: 0;
  min-height: 100%;
  min-width: 100%;
  height: auto;
  width: auto;
  opacity: 0;
  z-index: 99;
  background-color: #fff;
  filter: alpha(opacity=0);
}

.select2-hidden-accessible {
  border: 0 !important;
  clip: rect(0 0 0 0) !important;
  height: 1px !important;
  margin: -1px !important;
  overflow: hidden !important;
  padding: 0 !important;
  position: absolute !important;
  width: 1px !important;
}

.select2-container--default .select2-selection--single {
  background-color: #fff;
  border: 1px solid #adb5bd;
  border-radius: 4px;
}

.select2-container--default .select2-selection--single .select2-selection__rendered {
  color: #555;
  font-size: 14px;
  line-height: 28px;
}

.select2-container--default .select2-selection--single .select2-selection__clear {
  cursor: pointer;
  float: right;
  font-weight: bold;
}

.select2-container--default .select2-selection--single .select2-selection__placeholder {
  color: #999;
}

.select2-container--default .select2-selection--single .select2-selection__arrow {
  height: 26px;
  position: absolute;
  top: 1px;
  right: 1px;
  width: 20px;
}

.select2-container--default .select2-selection--single .select2-selection__arrow b {
  border-color: #888 transparent transparent transparent;
  border-style: solid;
  border-width: 5px 4px 0 4px;
  height: 0;
  left: 50%;
  margin-left: -4px;
  margin-top: -2px;
  position: absolute;
  top: 50%;
  width: 0;
}

.select2-container--default[dir="rtl"] .select2-selection--single .select2-selection__clear {
  float: left;
}

.select2-container--default[dir="rtl"] .select2-selection--single .select2-selection__arrow {
  left: 1px;
  right: auto;
}

.select2-container--default.select2-container--disabled .select2-selection--single {
  background-color: #E5E5E5;
  cursor: default;
}

.select2-container--default.select2-container--disabled .select2-selection--single .select2-selection__clear {
  display: none;
}

.select2-container--default.select2-container--open .select2-selection--single .select2-selection__arrow b {
  border-color: transparent transparent #888 transparent;
  border-width: 0 4px 5px 4px;
}

.select2-container--default .select2-selection--multiple {
  background-color: #fff;
  border: 1px solid #adb5bd;
  border-radius: 4px;
  cursor: text;
}

.select2-container--default .select2-selection--multiple .select2-selection__rendered {
  box-sizing: border-box;
  list-style: none;
  margin: 0;
  padding: 0 5px;
  width: 100%;
}

.select2-container--default .select2-selection--multiple .select2-selection__rendered li {
  list-style: none;
}

.select2-container--default .select2-selection--multiple .select2-selection__placeholder {
  color: #999;
  margin-top: 5px;
  float: left;
}

.select2-container--default .select2-selection--multiple .select2-selection__clear {
  cursor: pointer;
  float: right;
  font-weight: bold;
  margin-top: 5px;
  margin-right: 10px;
}

.select2-container--default .select2-selection--multiple .select2-selection__choice {
  background-color: #e9ecef;
  border: 1px solid #adb5bd;
  border-radius: 4px;
  cursor: default;
  float: left;
  margin-right: 5px;
  margin-top: 5px;
  padding: 0 5px;
}

.select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
  color: #999;
  cursor: pointer;
  display: inline-block;
  font-weight: bold;
  margin-right: 2px;
}

.select2-container--default .select2-selection--multiple .select2-selection__choice__remove:hover {
  color: #343a40;
}

.select2-container--default[dir="rtl"] .select2-selection--multiple .select2-selection__choice, .select2-container--default[dir="rtl"] .select2-selection--multiple .select2-selection__placeholder, .select2-container--default[dir="rtl"] .select2-selection--multiple .select2-search--inline {
  float: right;
}

.select2-container--default[dir="rtl"] .select2-selection--multiple .select2-selection__choice {
  margin-left: 5px;
  margin-right: auto;
}

.select2-container--default[dir="rtl"] .select2-selection--multiple .select2-selection__choice__remove {
  margin-left: 2px;
  margin-right: auto;
}

.select2-container--default.select2-container--focus .select2-selection--multiple {
  border: solid #000 1px;
  outline: 0;
}

.select2-container--default.select2-container--disabled .select2-selection--multiple {
  background-color: #E5E5E5;
  cursor: default;
}

.select2-container--default.select2-container--disabled .select2-selection__choice__remove {
  display: none;
}

.select2-container--default.select2-container--open.select2-container--above .select2-selection--single, .select2-container--default.select2-container--open.select2-container--above .select2-selection--multiple {
  border-top-left-radius: 0;
  border-top-right-radius: 0;
}

.select2-container--default.select2-container--open.select2-container--below .select2-selection--single, .select2-container--default.select2-container--open.select2-container--below .select2-selection--multiple {
  border-bottom-left-radius: 0;
  border-bottom-right-radius: 0;
}

.select2-container--default .select2-search--dropdown .select2-search__field {
  border: 1px solid #adb5bd;
}

.select2-container--default .select2-search--inline .select2-search__field {
  background: transparent;
  border: none;
  outline: 0;
  box-shadow: none;
  -webkit-appearance: textfield;
}

.select2-container--default .select2-results > .select2-results__options {
  max-height: 200px;
  overflow-y: auto;
}

.select2-container--default .select2-results__option[role=group] {
  padding: 0;
}

.select2-container--default .select2-results__option[aria-disabled=true] {
  color: #999;
}

.select2-container--default .select2-results__option[aria-selected=true] {
  background-color: #DDD;
}

.select2-container--default .select2-results__option .select2-results__option {
  padding-left: 1em;
}

.select2-container--default .select2-results__option .select2-results__option .select2-results__group {
  padding-left: 0;
}

.select2-container--default .select2-results__option .select2-results__option .select2-results__option {
  margin-left: -1em;
  padding-left: 2em;
}

.select2-container--default .select2-results__option .select2-results__option .select2-results__option .select2-results__option {
  margin-left: -2em;
  padding-left: 3em;
}

.select2-container--default .select2-results__option .select2-results__option .select2-results__option .select2-results__option .select2-results__option {
  margin-left: -3em;
  padding-left: 4em;
}

.select2-container--default .select2-results__option .select2-results__option .select2-results__option .select2-results__option .select2-results__option .select2-results__option {
  margin-left: -4em;
  padding-left: 5em;
}

.select2-container--default .select2-results__option .select2-results__option .select2-results__option .select2-results__option .select2-results__option .select2-results__option .select2-results__option {
  margin-left: -5em;
  padding-left: 6em;
}

.select2-container--default .select2-results__option--highlighted[aria-selected] {
  background-color: #0073AA;
  color: #fff;
}

.select2-container--default .select2-results__group {
  cursor: default;
  display: block;
  padding: 6px;
}

.select2-container--classic .select2-selection--single {
  background-color: #f8f9fa;
  border: 1px solid #adb5bd;
  border-radius: 4px;
  outline: 0;
  background-image: -webkit-linear-gradient(top, #fff 50%, #E5E5E5 100%);
  background-image: -o-linear-gradient(top, #fff 50%, #E5E5E5 100%);
  background-image: linear-gradient(to bottom, #fff 50%, #E5E5E5 100%);
  background-repeat: repeat-x;
  filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='$whiteFFFFF', endColorstr='#FFEEEEEE', GradientType=0);
}

.select2-container--classic .select2-selection--single:focus {
  border: 1px solid #0073AA;
}

.select2-container--classic .select2-selection--single .select2-selection__rendered {
  color: #444;
  line-height: 28px;
}

.select2-container--classic .select2-selection--single .select2-selection__clear {
  cursor: pointer;
  float: right;
  font-weight: bold;
  margin-right: 10px;
}

.select2-container--classic .select2-selection--single .select2-selection__placeholder {
  color: #999;
}

.select2-container--classic .select2-selection--single .select2-selection__arrow {
  background-color: #DDD;
  border: none;
  border-left: 1px solid #adb5bd;
  border-top-right-radius: 4px;
  border-bottom-right-radius: 4px;
  height: 26px;
  position: absolute;
  top: 1px;
  right: 1px;
  width: 20px;
  background-image: -webkit-linear-gradient(top, #E5E5E5 50%, #adb5bd 100%);
  background-image: -o-linear-gradient(top, #E5E5E5 50%, #adb5bd 100%);
  background-image: linear-gradient(to bottom, #E5E5E5 50%, #adb5bd 100%);
  background-repeat: repeat-x;
  filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#FFEEEEEE', endColorstr='#FFCCCCCC', GradientType=0);
}

.select2-container--classic .select2-selection--single .select2-selection__arrow b {
  border-color: #888 transparent transparent transparent;
  border-style: solid;
  border-width: 5px 4px 0 4px;
  height: 0;
  left: 50%;
  margin-left: -4px;
  margin-top: -2px;
  position: absolute;
  top: 50%;
  width: 0;
}

.select2-container--classic[dir="rtl"] .select2-selection--single .select2-selection__clear {
  float: left;
}

.select2-container--classic[dir="rtl"] .select2-selection--single .select2-selection__arrow {
  border: none;
  border-right: 1px solid #adb5bd;
  border-radius: 0;
  border-top-left-radius: 4px;
  border-bottom-left-radius: 4px;
  left: 1px;
  right: auto;
}

.select2-container--classic.select2-container--open .select2-selection--single {
  border: 1px solid #0073AA;
}

.select2-container--classic.select2-container--open .select2-selection--single .select2-selection__arrow {
  background: transparent;
  border: none;
}

.select2-container--classic.select2-container--open .select2-selection--single .select2-selection__arrow b {
  border-color: transparent transparent #888 transparent;
  border-width: 0 4px 5px 4px;
}

.select2-container--classic.select2-container--open.select2-container--above .select2-selection--single {
  border-top: none;
  border-top-left-radius: 0;
  border-top-right-radius: 0;
  background-image: -webkit-linear-gradient(top, #fff 0%, #E5E5E5 50%);
  background-image: -o-linear-gradient(top, #fff 0%, #E5E5E5 50%);
  background-image: linear-gradient(to bottom, #fff 0%, #E5E5E5 50%);
  background-repeat: repeat-x;
  filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='$whiteFFFFF', endColorstr='#FFEEEEEE', GradientType=0);
}

.select2-container--classic.select2-container--open.select2-container--below .select2-selection--single {
  border-bottom: none;
  border-bottom-left-radius: 0;
  border-bottom-right-radius: 0;
  background-image: -webkit-linear-gradient(top, #E5E5E5 50%, #fff 100%);
  background-image: -o-linear-gradient(top, #E5E5E5 50%, #fff 100%);
  background-image: linear-gradient(to bottom, #E5E5E5 50%, #fff 100%);
  background-repeat: repeat-x;
  filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#FFEEEEEE', endColorstr='$whiteFFFFF', GradientType=0);
}

.select2-container--classic .select2-selection--multiple {
  background-color: #fff;
  border: 1px solid #adb5bd;
  border-radius: 4px;
  cursor: text;
  outline: 0;
}

.select2-container--classic .select2-selection--multiple:focus {
  border: 1px solid #0073AA;
}

.select2-container--classic .select2-selection--multiple .select2-selection__rendered {
  list-style: none;
  margin: 0;
  padding: 0 5px;
}

.select2-container--classic .select2-selection--multiple .select2-selection__clear {
  display: none;
}

.select2-container--classic .select2-selection--multiple .select2-selection__choice {
  background-color: #E5E5E5;
  border: 1px solid #adb5bd;
  border-radius: 4px;
  cursor: default;
  float: left;
  margin-right: 5px;
  margin-top: 5px;
  padding: 0 5px;
}

.select2-container--classic .select2-selection--multiple .select2-selection__choice__remove {
  color: #888;
  cursor: pointer;
  display: inline-block;
  font-weight: bold;
  margin-right: 2px;
}

.select2-container--classic .select2-selection--multiple .select2-selection__choice__remove:hover {
  color: #555;
}

.select2-container--classic[dir="rtl"] .select2-selection--multiple .select2-selection__choice {
  float: right;
}

.select2-container--classic[dir="rtl"] .select2-selection--multiple .select2-selection__choice {
  margin-left: 5px;
  margin-right: auto;
}

.select2-container--classic[dir="rtl"] .select2-selection--multiple .select2-selection__choice__remove {
  margin-left: 2px;
  margin-right: auto;
}

.select2-container--classic.select2-container--open .select2-selection--multiple {
  border: 1px solid #0073AA;
}

.select2-container--classic.select2-container--open.select2-container--above .select2-selection--multiple {
  border-top: none;
  border-top-left-radius: 0;
  border-top-right-radius: 0;
}

.select2-container--classic.select2-container--open.select2-container--below .select2-selection--multiple {
  border-bottom: none;
  border-bottom-left-radius: 0;
  border-bottom-right-radius: 0;
}

.select2-container--classic .select2-search--dropdown .select2-search__field {
  border: 1px solid #adb5bd;
  outline: 0;
}

.select2-container--classic .select2-search--inline .select2-search__field {
  outline: 0;
  box-shadow: none;
}

.select2-container--classic .select2-dropdown {
  background-color: #fff;
  border: 1px solid transparent;
}

.select2-container--classic .select2-dropdown--above {
  border-bottom: none;
}

.select2-container--classic .select2-dropdown--below {
  border-top: none;
}

.select2-container--classic .select2-results > .select2-results__options {
  max-height: 200px;
  overflow-y: auto;
}

.select2-container--classic .select2-results__option[role=group] {
  padding: 0;
}

.select2-container--classic .select2-results__option[aria-disabled=true] {
  color: #999;
}

.select2-container--classic .select2-results__option--highlighted[aria-selected] {
  background-color: #00B8DB;
  color: #fff;
}

.select2-container--classic .select2-results__group {
  cursor: default;
  display: block;
  padding: 6px;
}

.select2-container--classic.select2-container--open .select2-dropdown {
  border-color: #0073AA;
}

.tooltip {
  position: absolute;
  z-index: 1070;
  display: block;
  opacity: 0;
  font-size: 12px;
}

.tooltip.in {
  opacity: 0.9;
}

.tooltip.top {
  margin-top: -3px;
  padding: 5px 0;
}

.tooltip.right {
  margin-left: 3px;
  padding: 0 5px;
}

.tooltip.bottom {
  margin-top: 3px;
  padding: 5px 0;
}

.tooltip.left {
  margin-left: -3px;
  padding: 0 5px;
}

.tooltip-inner {
  max-width: 200px;
  padding: 3px 8px;
  color: #fff;
  text-align: center;
  background-color: #000;
  border-radius: 4px;
}

.tooltip-arrow {
  position: absolute;
  width: 0;
  height: 0;
  border-color: transparent;
  border-style: solid;
}

.tooltip.top .tooltip-arrow {
  bottom: 0;
  left: 50%;
  margin-left: -5px;
  border-width: 5px 5px 0;
  border-top-color: #000;
}

.tooltip.top-left .tooltip-arrow {
  bottom: 0;
  right: 5px;
  margin-bottom: -5px;
  border-width: 5px 5px 0;
  border-top-color: #000;
}

.tooltip.top-right .tooltip-arrow {
  bottom: 0;
  left: 5px;
  margin-bottom: -5px;
  border-width: 5px 5px 0;
  border-top-color: #000;
}

.tooltip.right .tooltip-arrow {
  top: 50%;
  left: 0;
  margin-top: -5px;
  border-width: 5px 5px 5px 0;
  border-right-color: #000;
}

.tooltip.left .tooltip-arrow {
  top: 50%;
  right: 0;
  margin-top: -5px;
  border-width: 5px 0 5px 5px;
  border-left-color: #000;
}

.tooltip.bottom .tooltip-arrow {
  top: 0;
  left: 50%;
  margin-left: -5px;
  border-width: 0 5px 5px;
  border-bottom-color: #000;
}

.tooltip.bottom-left .tooltip-arrow {
  top: 0;
  right: 5px;
  margin-top: -5px;
  border-width: 0 5px 5px;
  border-bottom-color: #000;
}

.tooltip.bottom-right .tooltip-arrow {
  top: 0;
  left: 5px;
  margin-top: -5px;
  border-width: 0 5px 5px;
  border-bottom-color: #000;
}

.swal2-container {
  z-index: 100000000;
}

.swal2-container .swal2-content, .swal2-container .swal2-title {
  margin-bottom: 30px;
}

.swal2-container .swal2-title {
  line-height: 1.3;
  font-size: 23px;
}

.swal2-container p {
  font-size: 15px;
  text-align: center;
}

.swal2-container button, .swal2-container a {
  -webkit-transition: background-color 0.2s ease-in-out;
  -o-transition: background-color 0.2s ease-in-out;
  transition: background-color 0.2s ease-in-out;
}

.swal2-container button:focus, .swal2-container a:focus {
  outline: none;
  box-shadow: none;
}

.swal2-container a {
  text-decoration: none;
  color: #69C61D;
}

.swal2-container a:hover {
  color: #82e135;
}

.swal2-container .atum-loading {
  width: 18px;
  height: 18px;
  border: 3px solid rgba(0, 184, 219, 0.25);
  border-top-color: #00B8DB;
  border-radius: 50%;
  position: absolute;
  z-index: 50;
  -webkit-animation: loader-rotate 1s linear infinite;
  -moz-animation: loader-rotate 1s linear infinite;
  -o-animation: loader-rotate 1s linear infinite;
  animation: loader-rotate 1s linear infinite;
  top: 30px;
  left: 0;
  right: 0;
  margin: auto;
  width: 40px;
  height: 40px;
  border-width: 3px;
}

@-webkit-keyframes loader-rotate {
  from {
    -webkit-transform: rotate(0deg);
  }
  to {
    -webkit-transform: rotate(360deg);
  }
}

@-moz-keyframes loader-rotate {
  from {
    -moz-transform: rotate(0deg);
  }
  to {
    -moz-transform: rotate(360deg);
  }
}

@-o-keyframes loader-rotate {
  from {
    -o-transform: rotate(0deg);
  }
  to {
    -o-transform: rotate(360deg);
  }
}

@keyframes loader-rotate {
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(360deg);
  }
}

.blockUI.blockOverlay:before {
  display: none;
}

.blockUI.blockOverlay:after {
  content: '';
  top: 45%;
  left: 0;
  right: 0;
  margin: auto;
  width: 30px;
  height: 30px;
  border: 3px solid rgba(227, 232, 245, 0.25);
  border-top-color: #E3E8F5;
  border-radius: 50%;
  position: absolute;
  z-index: 50;
  -webkit-animation: loader-rotate 1s linear infinite;
  -moz-animation: loader-rotate 1s linear infinite;
  -o-animation: loader-rotate 1s linear infinite;
  animation: loader-rotate 1s linear infinite;
}

@-webkit-keyframes loader-rotate {
  from {
    -webkit-transform: rotate(0deg);
  }
  to {
    -webkit-transform: rotate(360deg);
  }
}

@-moz-keyframes loader-rotate {
  from {
    -moz-transform: rotate(0deg);
  }
  to {
    -moz-transform: rotate(360deg);
  }
}

@-o-keyframes loader-rotate {
  from {
    -o-transform: rotate(0deg);
  }
  to {
    -o-transform: rotate(360deg);
  }
}

@keyframes loader-rotate {
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(360deg);
  }
}

.note .blockUI.blockOverlay:after {
  top: 38%;
  width: 25px;
  height: 25px;
  border: 2px solid rgba(227, 232, 245, 0.25);
  border-top-color: #E3E8F5;
  border-radius: 50%;
  position: absolute;
  z-index: 50;
  -webkit-animation: loader-rotate 1s linear infinite;
  -moz-animation: loader-rotate 1s linear infinite;
  -o-animation: loader-rotate 1s linear infinite;
  animation: loader-rotate 1s linear infinite;
}

@-webkit-keyframes loader-rotate {
  from {
    -webkit-transform: rotate(0deg);
  }
  to {
    -webkit-transform: rotate(360deg);
  }
}

@-moz-keyframes loader-rotate {
  from {
    -moz-transform: rotate(0deg);
  }
  to {
    -moz-transform: rotate(360deg);
  }
}

@-o-keyframes loader-rotate {
  from {
    -o-transform: rotate(0deg);
  }
  to {
    -o-transform: rotate(360deg);
  }
}

@keyframes loader-rotate {
  from {
    transform: rotate(0deg);
  }
  to {
    transform: rotate(360deg);
  }
}

.color-primary {
  color: #00B8DB;
}

.color-info {
  color: #E3E8F5;
}

.color-success {
  color: #69C61D;
}

.color-warning {
  color: #EFAF00;
}

.color-danger {
  color: #FF4848;
}

.bg-primary {
  background-color: #00B8DB;
}

.bg-info {
  background-color: #E3E8F5;
}

.bg-success {
  background-color: #69C61D;
}

.bg-warning {
  background-color: #EFAF00;
}

.bg-danger {
  background-color: #FF4848;
}

.embed-responsive {
  position: relative;
  display: block;
  width: 100%;
  padding: 0;
  overflow: hidden;
}

.embed-responsive::before {
  display: block;
  content: "";
}

.embed-responsive .embed-responsive-item, .embed-responsive iframe, .embed-responsive embed, .embed-responsive object, .embed-responsive video {
  position: absolute;
  top: 0;
  bottom: 0;
  left: 0;
  width: 100%;
  height: 100%;
  border: 0;
}

.embed-responsive-21by9::before {
  padding-top: 42.85714%;
}

.embed-responsive-16by9::before {
  padding-top: 56.25%;
}

.embed-responsive-4by3::before {
  padding-top: 75%;
}

.embed-responsive-1by1::before {
  padding-top: 100%;
}

.atum-meta-box {
  padding: 15px 10px;
}

.atum-meta-box::after {
  display: block;
  clear: both;
  content: "";
}

.atum-meta-box .form-field {
  float: left;
  clear: left;
  width: 48%;
  padding: 0;
  margin: 9px 0 0;
  color: #777;
}

.atum-meta-box .form-field label {
  display: block;
  padding: 0 0 3px;
}

.atum-meta-box .form-field > input, .atum-meta-box .form-field > select, .atum-meta-box .form-field > textarea {
  width: 100%;
}

.atum-meta-box .form-field input {
  height: 32px;
  border-radius: 4px;
  box-shadow: none;
}

.atum-meta-box .form-field .select2-container {
  width: 100% !important;
}

.atum-meta-box .form-field .date-picker {
  width: 50%;
}

.atum-meta-box .form-field .switchery {
  margin-left: 7px;
}

.atum-meta-box .form-field.atum-editor {
  margin-top: 15px;
}

.atum-meta-box .form-field.atum-editor label {
  margin-bottom: -30px;
}

.atum-meta-box .form-field.form-field-wide {
  width: 100%;
  clear: both;
}

.atum-meta-box .form-field.form-field-wide > .wc-customer-search, .atum-meta-box .form-field.form-field-wide > .wc-enhanced-select, .atum-meta-box .form-field.form-field-wide > input, .atum-meta-box .form-field.form-field-wide > select, .atum-meta-box .form-field.form-field-wide > textarea, .atum-meta-box .form-field.form-field-wide .select2-container {
  width: 100%;
}

.atum-meta-box .form-field .wp-editor-area {
  border: none;
}

.wc-backbone-modal * {
  box-sizing: border-box;
}

.wc-backbone-modal .wc-backbone-modal-content {
  position: fixed;
  background: #fff;
  z-index: 100000;
  left: 50%;
  top: 50%;
  transform: translate(-50%, -50%);
  width: 500px;
}

.wc-backbone-modal .wc-backbone-modal-content article {
  overflow: auto;
}

.wc-backbone-modal.wc-backbone-modal-shipping-method-settings .wc-backbone-modal-content {
  width: 75%;
  min-width: 500px;
}

.wc-backbone-modal .select2-container {
  width: 100% !important;
}

.wc-backbone-modal .alert {
  background-color: #8fedff;
  padding: 4px 6px;
  display: block;
  font-size: 12px;
  margin-bottom: 5px;
}

body.allow-multiple-suppliers .wc-backbone-modal .alert {
  display: none;
}

.wc-backbone-modal-backdrop {
  position: fixed;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  min-height: 360px;
  background: #000;
  opacity: 0.7;
  z-index: 99900;
}

.wc-backbone-modal-main {
  padding-bottom: 55px;
}

.wc-backbone-modal-main header,
.wc-backbone-modal-main article {
  display: block;
  position: relative;
}

.wc-backbone-modal-main .wc-backbone-modal-header {
  height: auto;
  background: #fcfcfc;
  padding: 1em 1.5em;
  border-bottom: 1px solid #DDD;
}

.wc-backbone-modal-main .wc-backbone-modal-header h1 {
  margin: 0;
  font-size: 18px;
  font-weight: 700;
  line-height: 1.5em;
}

.wc-backbone-modal-main .wc-backbone-modal-header .modal-close-link {
  cursor: pointer;
  color: #777;
  height: 54px;
  width: 54px;
  padding: 0;
  position: absolute;
  top: 0;
  right: 0;
  text-align: center;
  border: 0;
  border-left: 1px solid #DDD;
  background-color: transparent;
  -webkit-transition: color 0.1s ease-in-out, background 0.1s ease-in-out;
  transition: color 0.1s ease-in-out, background 0.1s ease-in-out;
}

.wc-backbone-modal-main .wc-backbone-modal-header .modal-close-link::before {
  font: normal 22px/50px 'dashicons' !important;
  color: #adb5bd;
  display: block;
  content: '\f335';
  font-weight: 300;
}

.wc-backbone-modal-main .wc-backbone-modal-header .modal-close-link:hover, .wc-backbone-modal-main .wc-backbone-modal-header .modal-close-link:focus {
  background: #DDD;
  border-color: #ccc;
  color: #000;
}

.wc-backbone-modal-main .wc-backbone-modal-header .modal-close-link:focus {
  outline: none;
}

.wc-backbone-modal-main article {
  padding: 1.5em;
}

.wc-backbone-modal-main article p {
  margin: 1.5em 0;
}

.wc-backbone-modal-main article p:first-child {
  margin-top: 0;
}

.wc-backbone-modal-main article p:last-child {
  margin-bottom: 0;
}

.wc-backbone-modal-main article .pagination {
  padding: 10px 0 0;
  text-align: center;
}

.wc-backbone-modal-main footer {
  position: absolute;
  left: 0;
  right: 0;
  bottom: 0;
  z-index: 100;
  padding: 1em 1.5em;
  background: #fcfcfc;
  border-top: 1px solid #dfdfdf;
  box-shadow: 0 -4px 4px -4px rgba(0, 0, 0, 0.1);
}

.wc-backbone-modal-main footer .inner {
  float: right;
  line-height: 23px;
}

.wc-backbone-modal-main footer .inner .button {
  margin-bottom: 0;
}

.select2-drop, .select2-dropdown {
  z-index: 999999 !important;
}

.select2-results {
  line-height: 1.5em;
}

.select2-results .select2-results__option, .select2-results .select2-results__group {
  margin: 0;
  padding: 8px;
}

.select2-dropdown {
  border-color: #DDD;
}

.select2-dropdown--below {
  box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
}

.select2-dropdown--above {
  box-shadow: 0 -1px 1px rgba(0, 0, 0, 0.1);
}

.select2-container .select2-selection__rendered.ui-sortable li {
  cursor: move;
}

.select2-container .select2-selection {
  border-color: #DDD;
}

.select2-container .select2-search__field {
  min-width: 150px;
}

.select2-container .select2-selection--single {
  height: 32px;
}

.select2-container .select2-selection--single .select2-selection__rendered {
  line-height: 32px;
  padding-right: 24px;
}

.select2-container .select2-selection--single .select2-selection__arrow {
  right: 3px;
  height: 30px;
}

.select2-container .select2-selection--multiple {
  min-height: 28px;
  border-radius: 0;
  line-height: 1.5;
}

.select2-container .select2-selection--multiple li {
  margin: 0;
}

.select2-container .select2-selection--multiple .select2-selection__choice {
  padding: 2px 6px;
}

.select2-container .select2-selection__clear {
  color: #999;
  margin-top: -1px;
}

.select2-container .select2-search--inline .select2-search__field {
  font-family: inherit;
  font-size: inherit;
  font-weight: inherit;
  padding: 3px 0;
}

.select2-container:focus, .select2-container .selection:focus, .select2-container .select2-selection--single:focus {
  outline: none;
}

.atum-help-tip {
  color: #adb5bd;
  display: inline-block;
  font-size: 1.1em;
  font-style: normal;
  height: 16px;
  line-height: 16px;
  position: relative;
  vertical-align: middle;
  width: 16px;
}

.atum-help-tip::after {
  font-family: 'Dashicons';
  speak: none;
  font-weight: normal;
  font-variant: normal;
  text-transform: none;
  line-height: 1;
  -webkit-font-smoothing: antialiased;
  margin: 0;
  text-indent: 0;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  text-align: center;
  content: "";
  cursor: help;
}

h2 .atum-help-tip {
  margin-top: -5px;
  margin-left: 0.25em;
}

#atum_order_data .hndle, #atum_order_data .handlediv {
  display: none;
}

#atum_order_data .inside {
  padding: 0;
}

#atum_order_data .panel {
  padding: 23px 24px;
}

#atum_order_data .panel h2 {
  margin: 0;
  font-size: 21px;
  font-weight: 300;
  line-height: 1.2;
  text-shadow: 1px 1px 1px #fff;
  padding: 0;
}

#atum_order_data .panel h3 {
  font-size: 14px;
}

#atum_order_data .panel h3, #atum_order_data .panel h4 {
  color: #343a40;
  margin: 1.33em 0 0;
}

#atum_order_data .panel p.atum_order_number {
  margin: 0;
  line-height: 1.6em;
  font-size: 16px;
}

#atum_order_data .panel .atum_order_data_column_container {
  clear: both;
  margin-top: 15px;
}

#atum_order_data .panel .atum_order_data_column {
  width: 100%;
  padding: 0 2% 0 0;
  float: left;
}

#atum_order_data .panel .atum_order_data_column > h3 span {
  display: block;
}

#atum_order_data .panel .atum_order_data_column:last-child {
  padding-right: 0;
}

#atum_order_data .panel .atum_order_data_column p {
  padding: 0 !important;
}

#atum_order_data .panel .atum_order_data_column p.none_set {
  color: #999;
}

#atum_order_data .panel .atum_order_data_column .address strong {
  display: block;
}

#atum_order_data .panel .atum_order_data_column .hour, #atum_order_data .panel .atum_order_data_column .minute {
  width: 3.5em;
}

#atum_order_actions .atum-meta-box {
  padding: 0;
}

.atum_order_actions {
  margin: 0;
  overflow: hidden;
  zoom: 1;
}

.atum_order_actions li {
  padding: 6px 0;
  margin: 0;
  line-height: 1.6em;
  float: left;
  width: 50%;
  text-align: center;
}

.atum_order_actions li a {
  float: none;
  text-align: center;
  text-decoration: underline;
}

.atum_order_actions li.wide {
  width: auto;
  float: none;
  clear: both;
  padding: 6px;
  text-align: left;
  overflow: hidden;
}

.atum_order_actions li #delete-action {
  line-height: 25px;
  vertical-align: middle;
  text-align: left;
  float: left;
}

.atum_order_actions li .save-atum-order {
  float: right;
}

.atum_order_actions li#actions {
  overflow: hidden;
}

.atum_order_actions li#actions .button {
  width: 24px;
  box-sizing: border-box;
  float: right;
}

.atum_order_actions li#actions select {
  width: 225px;
  box-sizing: border-box;
  float: left;
}

#atum_order_notes .inside, #atum_order_notes .atum-meta-box {
  margin: 0;
  padding: 0;
}

ul.atum_order_notes {
  padding: 2px 0 0;
}

ul.atum_order_notes li {
  padding: 0 10px;
}

ul.atum_order_notes li .note_content {
  padding: 10px;
  background: #e9ecef;
  position: relative;
}

ul.atum_order_notes li .note_content p {
  margin: 0;
  padding: 0;
  word-wrap: break-word;
}

ul.atum_order_notes li p.meta {
  padding: 10px;
  color: #999;
  margin: 0;
  font-size: 11px;
}

ul.atum_order_notes li p.meta .exact-date {
  border-bottom: 1px dotted #999;
}

ul.atum_order_notes li a.delete_note {
  color: #FF4848;
}

ul.atum_order_notes li .note_content::after {
  content: '';
  display: block;
  position: absolute;
  bottom: -10px;
  left: 20px;
  width: 0;
  height: 0;
  border-width: 10px 10px 0 0;
  border-style: solid;
  border-color: #e9ecef transparent;
}

.add_note {
  border-top: 1px solid #DDD;
  padding: 10px 10px 0;
}

.add_note h4 {
  margin-top: 5px !important;
}

.add_note #add_atum_order_note {
  width: 100%;
  height: 70px;
  border-radius: 4px;
  margin-top: 4px;
  box-shadow: none;
}

#atum_order_items .inside {
  display: block !important;
  margin: 0;
  padding: 0;
  background: #f8f9fa;
}

#atum_order_items .atum-meta-box {
  padding: 0;
}

#atum_order_items .atum-order-data-row {
  border-bottom: 1px solid #dee2e6;
  padding: 1.5em 2em;
  background: #f8f9fa;
  line-height: 2em;
  text-align: right;
}

#atum_order_items .atum-order-data-row::after {
  display: block;
  clear: both;
  content: "";
}

#atum_order_items .atum-order-data-row p {
  margin: 0;
  line-height: 2em;
}

#atum_order_items .atum-order-data-row .atum-used-coupons {
  text-align: left;
}

#atum_order_items .atum-order-data-row .atum-used-coupons .tips {
  display: inline-block;
}

#atum_order_items .atum-used-coupons {
  float: left;
  width: 50%;
}

#atum_order_items .atum-order-totals {
  float: right;
  width: 50%;
  margin: 0;
  padding: 0;
  text-align: right;
}

#atum_order_items .atum-order-totals .amount {
  font-weight: 700;
}

#atum_order_items .atum-order-totals .label {
  vertical-align: top;
}

#atum_order_items .atum-order-totals .total {
  font-size: 1em !important;
  width: 10em;
  margin: 0 0 0 0.5em;
  box-sizing: border-box;
}

#atum_order_items .atum-order-totals .total input[type='text'] {
  width: 96%;
  float: right;
}

#atum_order_items .atum-order-totals .refunded-total {
  color: #FF4848;
}

#atum_order_items .refund-actions {
  margin-top: 5px;
  padding-top: 12px;
  border-top: 1px solid #dee2e6;
}

#atum_order_items .refund-actions .button {
  float: right;
  margin-left: 4px;
}

#atum_order_items .refund-actions .cancel-action {
  float: left;
  margin-left: 0;
}

#atum_order_items .atum-order-item-bulk-edit .cancel-action {
  float: left;
  margin-left: 0;
}

#atum_order_items .add_meta {
  margin-left: 0 !important;
}

#atum_order_items h3 small {
  color: #999;
}

#atum_order_items .amount {
  white-space: nowrap;
}

#atum_order_items .add-items .description {
  margin-right: 10px;
}

#atum_order_items .add-items .button {
  float: left;
  margin-right: 0.25em;
}

#atum_order_items .add-items .button-primary {
  float: none;
  margin-right: 0;
}

#atum_order_items .hndle, #atum_order_items .handlediv {
  display: none;
}

#atum_order_items .atum_order_items_wrapper {
  margin: 0;
  overflow-x: auto;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items {
  width: 100%;
  background: #fff;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items thead th {
  text-align: left;
  padding: 1em;
  font-weight: normal;
  color: #999;
  background: #f9f9f9;
  -webkit-touch-callout: none;
  -webkit-user-select: none;
  -moz-user-select: none;
  -ms-user-select: none;
  user-select: none;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items thead th.sortable {
  cursor: pointer;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items thead th:last-child {
  padding-right: 2em;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items thead th:first-child {
  padding-left: 2em;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items thead th .atum-arrow {
  float: right;
  position: relative;
  margin-right: -1em;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tbody th, #atum_order_items .atum_order_items_wrapper table.atum_order_items td {
  padding: 1.5em 1em 1em;
  text-align: left;
  line-height: 1.5em;
  vertical-align: top;
  border-bottom: 1px solid #f9f9f9;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tbody th textarea, #atum_order_items .atum_order_items_wrapper table.atum_order_items td textarea {
  width: 100%;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tbody th select, #atum_order_items .atum_order_items_wrapper table.atum_order_items td select {
  width: 50%;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tbody th input, #atum_order_items .atum_order_items_wrapper table.atum_order_items tbody th textarea, #atum_order_items .atum_order_items_wrapper table.atum_order_items td input, #atum_order_items .atum_order_items_wrapper table.atum_order_items td textarea {
  font-size: 14px;
  padding: 4px;
  color: #555;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tbody th:last-child, #atum_order_items .atum_order_items_wrapper table.atum_order_items td:last-child {
  padding-right: 2em;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tbody th:first-child, #atum_order_items .atum_order_items_wrapper table.atum_order_items td:first-child {
  padding-left: 2em;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tbody tr td {
  cursor: pointer;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tbody tr.selected {
  background: #F5EBF3;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tbody tr.selected td {
  border-color: #E6CCE1;
  opacity: 0.8;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tbody tr:last-child td {
  border-bottom: 1px solid #dee2e6;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tbody tr:first-child td {
  border-top: 8px solid #f9f9f9;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tbody#order_line_items tr:first-child td {
  border-top: none;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items td.thumb {
  text-align: left;
  width: 38px;
  padding-bottom: 1.5em;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items td.thumb .atum-order-item-thumbnail {
  width: 38px;
  height: 38px;
  border: 2px solid #e9ecef;
  background: #f9f9f9;
  color: #ccc;
  position: relative;
  font-size: 21px;
  display: block;
  text-align: center;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items td.thumb .atum-order-item-thumbnail::before {
  font-family: 'Dashicons';
  speak: none;
  font-weight: normal;
  font-variant: normal;
  text-transform: none;
  line-height: 1;
  -webkit-font-smoothing: antialiased;
  margin: 0;
  text-indent: 0;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  text-align: center;
  content: "";
  width: 38px;
  line-height: 38px;
  display: block;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items td.thumb .atum-order-item-thumbnail img {
  width: 100%;
  height: 100%;
  margin: 0;
  padding: 0;
  position: relative;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items td.name .atum-order-item-sku, #atum_order_items .atum_order_items_wrapper table.atum_order_items td.name .atum-order-item-variation {
  display: block;
  margin-top: 0.5em;
  font-size: 0.92em !important;
  color: #888;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .item {
  min-width: 200px;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .center, #atum_order_items .atum_order_items_wrapper table.atum_order_items .variation-id {
  text-align: center;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost {
  text-align: right;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost label {
  white-space: nowrap;
  color: #999;
  font-size: 0.833em;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost label input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax label input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity label input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost label input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax label input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class label input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost label input {
  display: inline;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost input {
  width: 70px;
  vertical-align: middle;
  text-align: right;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost select, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax select, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity select, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost select, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax select, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class select, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost select {
  width: 85px;
  height: 26px;
  vertical-align: middle;
  font-size: 1em;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .split-input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .split-input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .split-input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .split-input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .split-input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .split-input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .split-input {
  display: inline-block;
  background: #fff;
  border: 1px solid #DDD;
  box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.07);
  margin: 1px 0;
  min-width: 80px;
  overflow: hidden;
  line-height: 1em;
  text-align: right;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .split-input div.input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .split-input div.input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .split-input div.input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .split-input div.input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .split-input div.input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .split-input div.input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .split-input div.input {
  width: 100%;
  box-sizing: border-box;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .split-input div.input label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .split-input div.input label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .split-input div.input label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .split-input div.input label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .split-input div.input label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .split-input div.input label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .split-input div.input label {
  font-size: 0.75em;
  padding: 4px 6px 0;
  color: #555;
  display: block;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .split-input div.input input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .split-input div.input input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .split-input div.input input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .split-input div.input input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .split-input div.input input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .split-input div.input input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .split-input div.input input {
  width: 100%;
  box-sizing: border-box;
  border: 0;
  box-shadow: none;
  margin: 0;
  padding: 0 6px 4px;
  color: #555;
  background: transparent;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .split-input div.input input::-moz-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .split-input div.input input::-moz-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .split-input div.input input::-moz-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .split-input div.input input::-moz-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .split-input div.input input::-moz-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .split-input div.input input::-moz-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .split-input div.input input::-moz-placeholder {
  color: #DDD;
  opacity: 1;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .split-input div.input input:-ms-input-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .split-input div.input input:-ms-input-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .split-input div.input input:-ms-input-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .split-input div.input input:-ms-input-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .split-input div.input input:-ms-input-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .split-input div.input input:-ms-input-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .split-input div.input input:-ms-input-placeholder {
  color: #DDD;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .split-input div.input input::-webkit-input-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .split-input div.input input::-webkit-input-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .split-input div.input input::-webkit-input-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .split-input div.input input::-webkit-input-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .split-input div.input input::-webkit-input-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .split-input div.input input::-webkit-input-placeholder, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .split-input div.input input::-webkit-input-placeholder {
  color: #DDD;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .split-input div.input:first-child, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .split-input div.input:first-child, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .split-input div.input:first-child, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .split-input div.input:first-child, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .split-input div.input:first-child, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .split-input div.input:first-child, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .split-input div.input:first-child {
  border-bottom: 1px dashed #DDD;
  background: #fff;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .split-input div.input:first-child label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .split-input div.input:first-child input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .split-input div.input:first-child label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .split-input div.input:first-child input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .split-input div.input:first-child label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .split-input div.input:first-child input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .split-input div.input:first-child label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .split-input div.input:first-child input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .split-input div.input:first-child label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .split-input div.input:first-child input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .split-input div.input:first-child label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .split-input div.input:first-child input, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .split-input div.input:first-child label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .split-input div.input:first-child input {
  color: #ccc;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .view, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .view, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .view, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .view, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .view, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .view, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .view {
  white-space: nowrap;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .edit, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .edit, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .edit, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .edit, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .edit, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .edit, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .edit {
  text-align: left;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost small.times, #atum_order_items .atum_order_items_wrapper table.atum_order_items .cost del, #atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .atum-order-item-taxes, #atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .atum-order-item-discount, #atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .atum-order-item-refund-fields, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax small.times, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax del, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .atum-order-item-taxes, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .atum-order-item-discount, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .atum-order-item-refund-fields, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity small.times, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity del, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .atum-order-item-taxes, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .atum-order-item-discount, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .atum-order-item-refund-fields, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost small.times, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost del, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .atum-order-item-taxes, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .atum-order-item-discount, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .atum-order-item-refund-fields, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax small.times, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax del, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .atum-order-item-taxes, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .atum-order-item-discount, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .atum-order-item-refund-fields, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class small.times, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class del, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .atum-order-item-taxes, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .atum-order-item-discount, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .atum-order-item-refund-fields, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost small.times, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost del, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .atum-order-item-taxes, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .atum-order-item-discount, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .atum-order-item-refund-fields {
  font-size: 0.92em !important;
  color: #888;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .atum-order-item-taxes, #atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .atum-order-item-refund-fields, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .atum-order-item-taxes, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .atum-order-item-refund-fields, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .atum-order-item-taxes, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .atum-order-item-refund-fields, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .atum-order-item-taxes, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .atum-order-item-refund-fields, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .atum-order-item-taxes, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .atum-order-item-refund-fields, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .atum-order-item-taxes, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .atum-order-item-refund-fields, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .atum-order-item-taxes, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .atum-order-item-refund-fields {
  margin: 0;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .atum-order-item-taxes label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .atum-order-item-refund-fields label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .atum-order-item-taxes label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .atum-order-item-refund-fields label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .atum-order-item-taxes label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .atum-order-item-refund-fields label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .atum-order-item-taxes label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .atum-order-item-refund-fields label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .atum-order-item-taxes label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .atum-order-item-refund-fields label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .atum-order-item-taxes label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .atum-order-item-refund-fields label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .atum-order-item-taxes label, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .atum-order-item-refund-fields label {
  display: block;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost .atum-order-item-discount, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax .atum-order-item-discount, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity .atum-order-item-discount, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost .atum-order-item-discount, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax .atum-order-item-discount, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class .atum-order-item-discount, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost .atum-order-item-discount {
  display: block;
  margin-top: 0.5em;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .cost small.times, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax small.times, #atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity small.times, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_cost small.times, #atum_order_items .atum_order_items_wrapper table.atum_order_items .line_tax small.times, #atum_order_items .atum_order_items_wrapper table.atum_order_items .tax_class small.times, #atum_order_items .atum_order_items_wrapper table.atum_order_items .item_cost small.times {
  margin-right: 0.25em;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity {
  text-align: center;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .quantity input {
  text-align: center;
  width: 50px;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items span.subtotal {
  opacity: 0.5;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items td.tax_class, #atum_order_items .atum_order_items_wrapper table.atum_order_items th.tax_class {
  text-align: left;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .calculated {
  border-color: #eba3a3;
  border-style: dotted;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items table.meta {
  width: 100%;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items table.meta button {
  padding-left: 7px;
  padding-right: 7px;
  font-size: 12px;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items table.meta, #atum_order_items .atum_order_items_wrapper table.atum_order_items table.display_meta {
  margin: 0.5em 0 0;
  font-size: 0.92em !important;
  color: #888;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items table.meta tr th, #atum_order_items .atum_order_items_wrapper table.atum_order_items table.display_meta tr th {
  border: 0;
  padding: 0 4px 0.5em 0;
  line-height: 1.5em;
  width: 20%;
  white-space: nowrap;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items table.meta tr td, #atum_order_items .atum_order_items_wrapper table.atum_order_items table.display_meta tr td {
  padding: 0 4px 0.5em 0;
  border: 0;
  line-height: 1.5em;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items table.meta tr td input, #atum_order_items .atum_order_items_wrapper table.atum_order_items table.display_meta tr td input {
  width: 100%;
  margin: 0;
  position: relative;
  border-bottom: 0;
  box-shadow: none;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items table.meta tr td textarea, #atum_order_items .atum_order_items_wrapper table.atum_order_items table.display_meta tr td textarea {
  width: 100%;
  height: 4em;
  margin: 0;
  box-shadow: none;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items table.meta tr td input:focus + textarea, #atum_order_items .atum_order_items_wrapper table.atum_order_items table.display_meta tr td input:focus + textarea {
  border-top-color: #999;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items table.meta tr td p, #atum_order_items .atum_order_items_wrapper table.atum_order_items table.display_meta tr td p {
  margin: 0 0 0.5em;
  line-height: 1.5em;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items table.meta tr td p:last-child, #atum_order_items .atum_order_items_wrapper table.atum_order_items table.display_meta tr td p:last-child {
  margin: 0;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items .refund_by {
  border-bottom: 1px dotted #999;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tr.fee .thumb div, #atum_order_items .atum_order_items_wrapper table.atum_order_items tr.refund .thumb div, #atum_order_items .atum_order_items_wrapper table.atum_order_items tr.shipping .thumb div {
  display: block;
  text-indent: -9999px;
  position: relative;
  height: 1em;
  width: 1em;
  font-size: 1.5em;
  line-height: 1em;
  vertical-align: middle;
  margin: 0;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tr.fee .thumb div:before, #atum_order_items .atum_order_items_wrapper table.atum_order_items tr.refund .thumb div:before, #atum_order_items .atum_order_items_wrapper table.atum_order_items tr.shipping .thumb div:before {
  color: #adb5bd;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tr.fee .thumb div:before {
  font-family: 'WooCommerce';
  speak: none;
  font-weight: normal;
  font-variant: normal;
  text-transform: none;
  line-height: 1;
  -webkit-font-smoothing: antialiased;
  margin: 0;
  text-indent: 0;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  text-align: center;
  content: "";
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tr.refund .thumb div:before {
  font-family: 'WooCommerce';
  speak: none;
  font-weight: normal;
  font-variant: normal;
  text-transform: none;
  line-height: 1;
  -webkit-font-smoothing: antialiased;
  margin: 0;
  text-indent: 0;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  text-align: center;
  content: "";
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tr.shipping .thumb div:before {
  font-family: 'WooCommerce';
  speak: none;
  font-weight: normal;
  font-variant: normal;
  text-transform: none;
  line-height: 1;
  -webkit-font-smoothing: antialiased;
  margin: 0;
  text-indent: 0;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  text-align: center;
  content: "";
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items tr.shipping .shipping_method_name, #atum_order_items .atum_order_items_wrapper table.atum_order_items tr.shipping .shipping_method {
  width: 100%;
  margin: 0 0 0.5em;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items th.line_tax {
  white-space: nowrap;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items th.line_tax .delete-atum-order-tax, #atum_order_items .atum_order_items_wrapper table.atum_order_items td.line_tax .delete-atum-order-tax {
  display: block;
  text-indent: -9999px;
  position: relative;
  height: 1em;
  width: 1em;
  float: right;
  font-size: 14px;
  visibility: hidden;
  margin: 3px -18px 0 0;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items th.line_tax .delete-atum-order-tax:before, #atum_order_items .atum_order_items_wrapper table.atum_order_items td.line_tax .delete-atum-order-tax:before {
  font-family: 'Dashicons';
  speak: none;
  font-weight: normal;
  font-variant: normal;
  text-transform: none;
  line-height: 1;
  -webkit-font-smoothing: antialiased;
  margin: 0;
  text-indent: 0;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  text-align: center;
  content: "";
  color: #999;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items th.line_tax .delete-atum-order-tax:hover:before, #atum_order_items .atum_order_items_wrapper table.atum_order_items td.line_tax .delete-atum-order-tax:hover:before {
  color: #FF4848;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items th.line_tax:hover .delete-atum-order-tax, #atum_order_items .atum_order_items_wrapper table.atum_order_items td.line_tax:hover .delete-atum-order-tax {
  visibility: visible;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items small.refunded {
  display: block;
  color: #FF4848;
  white-space: nowrap;
  margin-top: 0.5em;
}

#atum_order_items .atum_order_items_wrapper table.atum_order_items small.refunded:before {
  font-family: 'Dashicons';
  speak: none;
  font-weight: normal;
  font-variant: normal;
  text-transform: none;
  line-height: 1;
  -webkit-font-smoothing: antialiased;
  margin: 0;
  text-indent: 0;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  text-align: center;
  content: "";
  position: relative;
  top: auto;
  left: auto;
  margin: -1px 4px 0 0;
  vertical-align: middle;
  line-height: 1em;
}

#atum_order_items .atum-order-edit-line-item {
  padding-left: 0;
}

#atum_order_items .atum-order-edit-line-item-actions {
  width: 44px;
  text-align: right;
  padding-left: 0;
  vertical-align: middle;
}

#atum_order_items .atum-order-edit-line-item-actions a {
  color: #adb5bd;
  display: inline-block;
  cursor: pointer;
  padding: 0 0 0.5em;
  margin: 0 0 0 12px;
  vertical-align: middle;
  text-decoration: none;
  line-height: 16px;
  width: 16px;
  overflow: hidden;
}

#atum_order_items .atum-order-edit-line-item-actions a:before {
  margin: 0;
  padding: 0;
  font-size: 16px;
  width: 16px;
  height: 16px;
}

#atum_order_items .atum-order-edit-line-item-actions a:hover:before {
  color: #999;
}

#atum_order_items .atum-order-edit-line-item-actions a:first-child {
  margin-left: 0;
}

#atum_order_items .atum-order-edit-line-item-actions .edit-atum-order-item:before {
  font-family: 'Dashicons';
  speak: none;
  font-weight: normal;
  font-variant: normal;
  text-transform: none;
  line-height: 1;
  -webkit-font-smoothing: antialiased;
  margin: 0;
  text-indent: 0;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  text-align: center;
  content: "";
  position: relative;
}

#atum_order_items .atum-order-edit-line-item-actions .edit-atum-order-item:focus {
  box-shadow: none;
}

#atum_order_items .atum-order-edit-line-item-actions .delete-atum-order-item:before, #atum_order_items .atum-order-edit-line-item-actions .delete_refund:before {
  font-family: 'Dashicons';
  speak: none;
  font-weight: normal;
  font-variant: normal;
  text-transform: none;
  line-height: 1;
  -webkit-font-smoothing: antialiased;
  margin: 0;
  text-indent: 0;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  text-align: center;
  content: "";
  position: relative;
}

#atum_order_items .atum-order-edit-line-item-actions .delete-atum-order-item:hover:before, #atum_order_items .atum-order-edit-line-item-actions .delete_refund:hover:before {
  color: #FF4848;
}

#atum_order_items .atum-order-edit-line-item-actions .delete-atum-order-item:focus, #atum_order_items .atum-order-edit-line-item-actions .delete_refund:focus {
  box-shadow: none;
}

#atum_order_items tbody tr .atum-order-edit-line-item-actions {
  visibility: hidden;
}

#atum_order_items tbody tr:hover .atum-order-edit-line-item-actions {
  visibility: visible;
}

#atum_order_items .atum-order-totals .atum-order-edit-line-item-actions {
  width: 1.5em;
  visibility: visible !important;
}

#atum_order_items .atum-order-totals .atum-order-edit-line-item-actions a {
  padding: 0;
}

.items-blocker {
  position: absolute;
  top: 0;
  bottom: 0;
  background: rgba(0, 0, 0, 0.5);
  z-index: 1;
}

.items-blocker, .items-blocker h3 {
  left: 0;
  right: 0;
}

.items-blocker h3 {
  color: #fff;
  font-size: 30px;
  line-height: 1.3;
  margin: 0;
  padding: 0 60px;
  position: absolute;
  top: 50%;
  -webkit-transform: translateY(-50%);
  -moz-transform: translateY(-50%);
  -o-transform: translateY(-50%);
  -ms-transform: translateY(-50%);
  transform: translateY(-50%);
  text-align: center;
}

.items-blocker:not(.unblocked) + .atum_order_items_wrapper #atum_order_line_items {
  display: none;
}

.items-blocker.unblocked {
  display: none;
}

.tips {
  cursor: help;
  text-decoration: none;
}

img.tips {
  padding: 5px 0 0;
}

#tiptip_holder {
  display: none;
  z-index: 8675309;
  position: absolute;
  top: 0;
  left: 0;
}

#tiptip_holder.tip_top {
  padding-bottom: 5px;
}

#tiptip_holder.tip_top #tiptip_arrow_inner {
  margin-top: -7px;
  margin-left: -6px;
  border-top-color: #343a40;
}

#tiptip_holder.tip_bottom {
  padding-top: 5px;
}

#tiptip_holder.tip_bottom #tiptip_arrow_inner {
  margin-top: -5px;
  margin-left: -6px;
  border-bottom-color: #343a40;
}

#tiptip_holder.tip_right {
  padding-left: 5px;
}

#tiptip_holder.tip_right #tiptip_arrow_inner {
  margin-top: -6px;
  margin-left: -5px;
  border-right-color: #343a40;
}

#tiptip_holder.tip_left {
  padding-right: 5px;
}

#tiptip_holder.tip_left #tiptip_arrow_inner {
  margin-top: -6px;
  margin-left: -7px;
  border-left-color: #343a40;
}

#tiptip_content {
  color: #fff;
  font-size: 0.8em;
  max-width: 150px;
  background: #343a40;
  text-align: center;
  border-radius: 3px;
  padding: 0.618em 1em;
  box-shadow: 0 1px 3px rgba(0, 0, 0, 0.2);
}

#tiptip_content code {
  padding: 1px;
  background: #888;
}

#tiptip_arrow, #tiptip_arrow_inner {
  position: absolute;
  border-color: transparent;
  border-style: solid;
  border-width: 6px;
  height: 0;
  width: 0;
}

table.wp-list-table .column-notes {
  width: 48px;
  text-align: center;
}

table.wp-list-table .column-notes img {
  margin: 0 auto;
  padding-top: 0 !important;
}

table.wp-list-table .column-title {
  width: 15%;
}

table.wp-list-table .column-title time {
  display: block;
  color: #999;
  margin: 3px 0;
}

table.wp-list-table .column-actions {
  width: 110px;
}

table.wp-list-table .column-actions a.button {
  float: left;
  margin: 0 4px 2px 0;
  cursor: pointer;
  padding: 3px 4px;
  height: auto;
}

table.wp-list-table .column-actions a.button img {
  display: block;
  width: 12px;
  height: auto;
}

table.wp-list-table .column-total, table.wp-list-table .column-date {
  width: 9%;
}

table.wp-list-table .column-status {
  text-align: center;
}

table.wp-list-table .column-status .order-status {
  display: -webkit-inline-box;
  display: -webkit-inline-flex;
  display: -ms-inline-flexbox;
  display: inline-flex;
  line-height: 2.5em;
  color: #6c757d;
  background: #f8f9fa;
  border-radius: 4px;
  border-bottom: 1px solid rgba(0, 0, 0, 0.05);
  margin: -.25em 0;
  cursor: inherit !important;
  white-space: nowrap;
  max-width: 100%;
}

table.wp-list-table .column-status .order-status.status-completed {
  background: #C8D7E1;
  color: #2e4453;
}

table.wp-list-table .column-status .order-status.status-on-hold {
  background: #f8dda7;
  color: #94660c;
}

table.wp-list-table .column-status .order-status.status-failed, table.wp-list-table .column-status .order-status.status-trash {
  background: #eba3a3;
  color: #761919;
}

table.wp-list-table .column-status .order-status.status-pending {
  background: #C6E1C6;
  color: #5B841B;
}

table.wp-list-table .column-status .order-status > span {
  margin: 0 1em;
  overflow: hidden;
  text-overflow: ellipsis;
}

table.wp-list-table td.column-status {
  padding-top: 9px;
}

table.wp-list-table .column-notes .note-on {
  display: block;
  text-indent: -9999px;
  position: relative;
  height: 1em;
  width: 1em;
  margin: 0 auto;
  color: #999;
}

table.wp-list-table .column-notes .note-on::after {
  font-family: 'WooCommerce';
  speak: none;
  font-weight: normal;
  font-variant: normal;
  text-transform: none;
  line-height: 1;
  -webkit-font-smoothing: antialiased;
  margin: 0;
  text-indent: 0;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  text-align: center;
  content: "";
  line-height: 16px;
}

table.wp-list-table .column-actions .pending, table.wp-list-table .column-actions .complete, table.wp-list-table .column-actions .view, table.wp-list-table .column-actions .pdf {
  display: block;
  text-indent: -9999px;
  position: relative;
  height: 1em;
  width: 1em;
  padding: 0 !important;
  height: 2em !important;
  width: 2em;
}

table.wp-list-table .column-actions .pending::after {
  font-family: 'WooCommerce';
  speak: none;
  font-weight: normal;
  font-variant: normal;
  text-transform: none;
  line-height: 1;
  -webkit-font-smoothing: antialiased;
  margin: 0;
  text-indent: 0;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  text-align: center;
  content: "";
  line-height: 1.85;
}

table.wp-list-table .column-actions .complete::after {
  font-family: 'Dashicons';
  speak: none;
  font-weight: normal;
  font-variant: normal;
  text-transform: none;
  line-height: 1;
  -webkit-font-smoothing: antialiased;
  margin: 0;
  text-indent: 0;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  text-align: center;
  content: "";
  line-height: 1.85;
}

table.wp-list-table .column-actions .view::after {
  font-family: 'Dashicons';
  speak: none;
  font-weight: normal;
  font-variant: normal;
  text-transform: none;
  line-height: 1;
  -webkit-font-smoothing: antialiased;
  margin: 0;
  text-indent: 0;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  text-align: center;
  content: "";
  line-height: 1.85;
}

table.wp-list-table .column-actions .pdf::after {
  content: url("../images/pdf.svg");
  position: absolute;
  top: 2px;
  left: 2px;
  width: 20px;
  z-index: 10;
  text-indent: 0;
}

table.wp-list-table img {
  margin: 1px 2px;
}

table.wp-list-table .row-actions, table.wp-list-table span.na {
  color: #999;
}

table.wp-list-table .notes_head, table.wp-list-table .notes_head, table.wp-list-table .status_head {
  display: block;
  text-indent: -9999px;
  position: relative;
  height: 1em;
  width: 1em;
  margin: 0 auto;
}

table.wp-list-table .notes_head::after, table.wp-list-table .notes_head::after, table.wp-list-table .status_head::after {
  font-family: 'WooCommerce';
  speak: none;
  font-weight: normal;
  font-variant: normal;
  text-transform: none;
  line-height: 1;
  -webkit-font-smoothing: antialiased;
  margin: 0;
  text-indent: 0;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  text-align: center;
  content: "";
}

table.wp-list-table .notes_head::after {
  content: '\e028';
}

table.wp-list-table .status_head::after {
  content: '\e011';
}
/*# sourceMappingURL=atum-orders.css.map */
