<?php 
    $settings_options = get_option( $this->globals['settings_option_key'] );
    $core_options = get_option( $this->globals['core_option_key'] );
?>

<div class="logo">
<center>
    <img src="<?= $this->globals['plugin_url']; ?>assets/images/logo.png" alt="<?= $this->globals['plugin_name']; ?>"></a>
</center>
</div>


<div class="page-container">
    <div class="page-content">

		<div class="page-settings row">
            <div class="col-md-10 col-md-offset-1">

                <div id="response-settings" style="display:none">
                    <button type="button" id="btn-clear-msg" data-id="response-settings" class="close"><span class="icon-cross"></span><span class="sr-only">Close</span></button>
                    <span id="msg"></span>
                </div>

                <div class="panel panel-flat">
                    <div class="panel-body">

                        <form id="form-settings" action="" method="POST">
                            <input type="hidden" name="action" value="dtcmc_settings_action">
                            <?php wp_nonce_field( 'dtcmc_settings_action', 'dtcmc_settings_nonce' ); ?>


                            <div class="tabbable">
                                <ul class="nav nav-tabs nav-tabs-bottom nav-justified">
                                    <li class="active"><a href="#tab-general" data-toggle="tab"><?= _e('General', 'dtcmc'); ?></a></li>
                                    <li><a href="#tab-branding" data-toggle="tab"><?= _e('Branding', 'dtcmc'); ?></a></li>
                                    <li><a href="#tab-color_scheme" data-toggle="tab"><?= _e('Color Scheme', 'dtcmc'); ?></a></li>
                                    <li><a href="#tab-layouts" data-toggle="tab"><?= _e('Layouts', 'dtcmc'); ?></a></li>
                                    <li><a href="#tab-analytics" data-toggle="tab"><?= _e('Analytics', 'dtcmc'); ?></a></li>
                                    <li><a href="#tab-custom-code" data-toggle="tab"><?= _e('Custom Code', 'dtcmc'); ?></a></li>
                                </ul>

                                <div class="tab-content">
                                    <button type="submit" class="pull-right btn btn-action btn-ladda save-spinner" data-style="zoom-out"><span class="ladda-label"><i class="icon-paperplane position-left"></i> <?= _e('Save Changes', 'dtcmc'); ?></span></button>
                            
                                    <div class="tab-pane fade in active" id="tab-general">
                                        <div class="form-group">

                                            <h2><?= _e('Configuration', 'dtcmc'); ?></h2>

                                            <hr class="divider mt-0">

                                            <div class="checkbox checkbox-right checkbox-switchery switchery-lg">
                                                <label class="display-block">
                                                    <input type="checkbox" class="switchery" name="enable_mcommerce" value="1" <?php checked(1, $settings_options['enable_mcommerce'], true); ?> /> 
                                                    <?= _e('Enable mCommerce', 'dtcmc'); ?> <i data-popup="tooltip" title="" data-original-title="If disabled mCommerce will be off for visitors using mobile devices." class="icon-info22"></i>
                                                </label>
                                            </div>

                                            <hr class="divider">

                                            <div class="checkbox checkbox-right checkbox-switchery switchery-lg">
                                                <label class="display-block">
                                                    <input type="checkbox" class="switchery" name="force_save" value="1" <?php checked(1, $settings_options['force_save'], true); ?> /> 
                                                    <?= _e('Force Save Settings', 'dtcmc'); ?> <i data-popup="tooltip" title="" data-original-title="If enabled your setting options will always be saved whenever the plugin is uninstalled." class="icon-info22"></i>
                                                </label>
                                            </div>

                                            <hr class="divider">

                                            <div class="row">
                                                <div class="col-sm-7">
                                                    <label class="control-label"><?= _e('Store Name', 'dtcmc'); ?></label>
                                                </div>
                                                <div class="col-sm-5 text-right">
                                                    <input type="text" name="site_title" class="form-control" value="<?= $settings_options['site_title']; ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="tab-pane fade in" id="tab-branding">
                                        <div class="form-group">
                                            <h2 class="mb-0"><?= _e('Site Logo', 'dtcmc'); ?></h2>
                                            <p>Recommended size 175x40</p>

                                            <br>

                                            <span id='site_logo-preview'>
                                                <img alt="" style="max-height: 60px; max-width: 220px; box-shadow: 0 1px 2px rgba(0,0,0,.1); background: #f8f8f8; padding: 4px;" src="<?= esc_url( $settings_options['site_logo'] ); ?>" />
                                            </span>

                                            <button type="button" data-identifier="site_logo" class="btn btn-xs btn-default action-image-upload"><?= _e('Upload', 'dtcmc'); ?></button>
                                            <button type="button" id="site_logo-delete" <?php if ( ! $settings_options['site_logo'] ) { echo "style='display: none;'"; } ?> class="btn btn-danger btn-ladda action-image-delete" data-identifier="site_logo" data-style="zoom-out"><span class="ladda-label"><?= _e('Delete', 'dtcmc'); ?></span></button>
                                        </div>

                                        <hr class="divider">

                                        <div class="form-group">
                                            <h2 class="mb-0"><?= _e('Home Slider', 'dtcmc'); ?></h2>
                                            <p>Recommended size 800x400</p>

                                            <br>

                                            <div class="row">
                                                <div class="col-sm-4">
                                                    <div class="slider-box">

                                                        <p class="text-center">Slider One</p>
                                                        <span id='home_slider_one-preview'>
                                                            <img alt="" style="max-width: 268px;" src="<?= esc_url( $settings_options['home_slider']['one'] ); ?>" />
                                                        </span>

                                                        <br>

                                                        <center>
                                                            <button type="button" data-identifier="home_slider_one" class="btn btn-xs btn-default action-image-upload"><?= _e('Upload', 'dtcmc'); ?></button>
                                                            <button type="button" id="home_slider_one-delete" <?php if ( ! $settings_options['home_slider']['one'] ) { echo "style='display: none;'"; } ?> class="btn btn-danger btn-ladda action-image-delete" data-identifier="home_slider_one" data-style="zoom-out"><span class="ladda-label"><?= _e('Delete', 'dtcmc'); ?></span></button>
                                                        </center>

                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="slider-box">
                                              
                                                        <p class="text-center">Slider Two</p>
                                                        <span id='home_slider_two-preview'>
                                                            <img alt="" style="max-width: 268px;" src="<?= esc_url( $settings_options['home_slider']['two'] ); ?>" />
                                                        </span>

                                                        <br>

                                                        <center>
                                                            <button type="button" data-identifier="home_slider_two" class="btn btn-xs btn-default action-image-upload"><?= _e('Upload', 'dtcmc'); ?></button>
                                                            <button type="button" id="home_slider_two-delete" <?php if ( ! $settings_options['home_slider']['two'] ) { echo "style='display: none;'"; } ?> class="btn btn-danger btn-ladda action-image-delete" data-identifier="home_slider_two" data-style="zoom-out"><span class="ladda-label"><?= _e('Delete', 'dtcmc'); ?></span></button>
                                                        </center>

                                                    </div>
                                                </div>
                                                <div class="col-sm-4">
                                                    <div class="slider-box">

                                                        <p class="text-center">Slider Three</p>
                                                        <span id='home_slider_three-preview'>
                                                            <img alt="" style="max-width: 268px;" src="<?= esc_url( $settings_options['home_slider']['three'] ); ?>" />
                                                        </span>

                                                        <br>

                                                        <center>
                                                            <button type="button" data-identifier="home_slider_three" class="btn btn-xs btn-default action-image-upload"><?= _e('Upload', 'dtcmc'); ?></button>
                                                            <button type="button" id="home_slider_three-delete" <?php if ( ! $settings_options['home_slider']['three'] ) { echo "style='display: none;'"; } ?> class="btn btn-danger btn-ladda action-image-delete" data-identifier="home_slider_three" data-style="zoom-out"><span class="ladda-label"><?= _e('Delete', 'dtcmc'); ?></span></button>
                                                        </center>

                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                        <hr class="divider">

                                        <div class="form-group">
                                            <?php
                                                $favicon_url = '';
                                                if ( $settings_options['favicon']['url'] ) {
                                                    $favicon_url = $settings_options['favicon']['url'].''.$settings_options['favicon']['name'].'.png'; 
                                                }
                                            ?>

                                            <h2 class="mb-0"><?= _e('Favicon', 'dtcmc'); ?></h2>
                                            <p>Recommended size 500x500, it will be resize for different devices</p>

                                            <span id='favicon-preview'>
                                                <img alt="" style="max-height: 32px; max-width: 32px;" src="<?= esc_url( $favicon_url ); ?>" />
                                            </span>

                                            <button type="button" data-identifier="favicon" class="btn btn-xs btn-default action-image-upload"><?= _e('Upload', 'dtcmc'); ?></button>
                                            <button type="button" id="favicon-delete" <?php if ( ! $favicon_url ) { echo "style='display: none;'"; } ?> class="btn btn-danger btn-ladda action-image-delete" data-identifier="favicon" data-style="zoom-out"><span class="ladda-label"><?= _e('Delete', 'dtcmc'); ?></span></button>
                                            <label id="favicon-error" class="validation-error-label"></label>
                                        </div>

                                        <div class="form-group">
                                            <label class="control-label"><?= _e('Windows Icon Tile Color', 'dtcmc'); ?></label>
                                            <br>
                                            <input type="text" name="win_tile_color" class="form-control colorpicker-show" data-preferred-format="hex" value="<?= $settings_options['favicon']['win_tile']; ?>">
                                        </div>
                                    </div>

                                    <div class="tab-pane fade" id="tab-color_scheme">
                                        
                                        <h2><?= _e('General Colors', 'dtcmc'); ?></h2>
                                         <div class="row">
                                            <div class="col-sm-6">

                                                <div class="form-group">
                                                    <label class="control-label"><?= _e('Body Background Color', 'dtcmc'); ?></label>
                                                    <br>
                                                    <input type="text" name="body_bg_color" class="form-control colorpicker-show" data-preferred-format="hex" value="<?= $settings_options['color_scheme']['body_bg_color']; ?>">
                                                </div>

                                                <br>

                                                <div class="form-group">
                                                    <label class="control-label"><?= _e('Primary Color', 'dtcmc'); ?></label>
                                                    <br>
                                                    <input type="text" name="primary_color" class="form-control colorpicker-show" data-preferred-format="hex" value="<?= $settings_options['color_scheme']['primary_color']; ?>">
                                                </div>

                                            </div>
                                            <div class="col-sm-6">

                                                <div class="form-group">
                                                    <label class="control-label"><?= _e('Links Color', 'dtcmc'); ?></label>
                                                    <br>
                                                    <input type="text" name="link_color" class="form-control colorpicker-show" data-preferred-format="hex" value="<?= $settings_options['color_scheme']['link_color']; ?>">
                                                </div>

                                                <br>

                                                <div class="form-group">
                                                    <label class="control-label"><?= _e('Browser Address Bar', 'dtcmc'); ?></label>
                                                    <br>
                                                    <input type="text" name="address_bar" class="form-control colorpicker-show" data-preferred-format="hex" value="<?= $settings_options['color_scheme']['address_bar']; ?>">
                                                </div>

                                            </div>
                                        </div>

                                        <hr class="divider">

                                        <h2><?= _e('Navbar Color', 'dtcmc'); ?></h2>

                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label class="control-label"><?= _e('Navbar Background Color', 'dtcmc'); ?></label>
                                                <div>
                                                    <input type="text" name="navbar_bg_color" class="form-control colorpicker-show" data-preferred-format="hex" value="<?= $settings_options['color_scheme']['navbar_bg_color']; ?>">
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="control-label"><?= _e('Navbar Text Color', 'dtcmc'); ?></label>
                                                <div>
                                                    <input type="text" name="navbar_text_color" class="form-control colorpicker-show" data-preferred-format="hex" value="<?= $settings_options['color_scheme']['navbar_text_color']; ?>">
                                                </div>
                                            </div>
                                        </div>

                                        <hr class="divider">

                                        <h2><?= _e('Button Color', 'dtcmc'); ?></h2>
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label class="control-label"><?= _e('Button Background', 'dtcmc'); ?></label>
                                                <div>
                                                    <input type="text" name="button_bg_color" class="form-control colorpicker-show" data-preferred-format="hex" value="<?= $settings_options['color_scheme']['button_bg_color']; ?>">
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="control-label"><?= _e('Button Text', 'dtcmc'); ?></label>
                                                <div>
                                                    <input type="text" name="button_text_color" class="form-control colorpicker-show" data-preferred-format="hex" value="<?= $settings_options['color_scheme']['button_text_color']; ?>">
                                                </div>
                                            </div>
                                        </div>

                                        <hr class="divider">

                                        <h2><?= _e('Sales Label Color', 'dtcmc'); ?></h2>
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label class="control-label"><?= _e('Label Background', 'dtcmc'); ?></label>
                                                <div>
                                                    <input type="text" name="label_bg_color" class="form-control colorpicker-show" data-preferred-format="hex" value="<?= $settings_options['color_scheme']['label_bg_color']; ?>">
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="control-label"><?= _e('Label Text', 'dtcmc'); ?></label>
                                                <div>
                                                    <input type="text" name="label_text_color" class="form-control colorpicker-show" data-preferred-format="hex" value="<?= $settings_options['color_scheme']['label_text_color']; ?>">
                                                </div>
                                            </div>
                                        </div>

                                        <hr class="divider">

                                        <h2><?= _e('Cart Badge Color', 'dtcmc'); ?></h2>
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label class="control-label"><?= _e('Badge Background', 'dtcmc'); ?></label>
                                                <div>
                                                    <input type="text" name="cart_badge_bg_color" class="form-control colorpicker-show" data-preferred-format="hex" value="<?= $settings_options['color_scheme']['cart_badge_bg_color']; ?>">
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <label class="control-label"><?= _e('Badge Text', 'dtcmc'); ?></label>
                                                <div>
                                                    <input type="text" name="cart_badge_text_color" class="form-control colorpicker-show" data-preferred-format="hex" value="<?= $settings_options['color_scheme']['cart_badge_text_color']; ?>">
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="tab-pane fade" id="tab-layouts">
                                        <h2><?= _e('Navigation Layouts', 'dtcmc'); ?></h2>

                                        <?php 
                                            $nav_selections = array(
                                                'Side Panel' => 'sidepanel',
                                                'Bottom Bar' => 'bottombar',
                                            );
                                        ?>

                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label class="control-label">Android Devices</label>
                                            </div>
                                            <div class="col-sm-6">
                                                <select name="android_navigation" class="form-control">
                                                    <?php foreach ($nav_selections as $key => $value) { ?>
                                                    <option value="<?= $value; ?>" <?php selected( $settings_options['layouts']['android_navigation'], $value ); ?>><?= $key; ?></option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>

                                        <br>

                                        <div class="row">
                                            <div class="col-sm-6">
                                                <label class="control-label">IOS Devices</label>
                                            </div>
                                            <div class="col-sm-6">
                                                <select name="ios_navigation" class="form-control">
                                                    <?php foreach ($nav_selections as $key => $value) { ?>
                                                    <option value="<?= $value; ?>" <?php selected( $settings_options['layouts']['ios_navigation'], $value ); ?>><?= $key; ?></option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <hr class="divider">

                                        <h2><?= _e('Home Page', 'dtcmc'); ?></h2>
                                        <label class="text-semibold">Layout Type</label>
                                        <div class="radio">
                                            <label>
                                                <input type="radio" name="layout_home" value="" <?php checked('', $settings_options['layouts']['home'], true); ?> />
                                                Default
                                            </label>
                                        </div>

                                        <div class="radio">
                                            <label>
                                                <input type="radio" name="layout_home" value="category" <?php checked('category', $settings_options['layouts']['home'], true); ?> />
                                                Categories
                                            </label>
                                        </div>

                                        <div class="radio">
                                            <label>
                                                <input type="radio" name="layout_home" value="grid" <?php checked('grid', $settings_options['layouts']['home'], true); ?> />
                                                Grid Block
                                            </label>
                                        </div>

                                        <div class="radio">
                                            <label>
                                                <input type="radio" name="layout_home" value="swipe" <?php checked('swipe', $settings_options['layouts']['home'], true); ?> />
                                                Swipe
                                            </label>
                                        </div>

                                        <hr class="divider">

                                        <h2><?= _e('Category Page', 'dtcmc'); ?></h2>
                                        <label class="text-semibold">Layout Type</label>
                                        <div class="radio">
                                            <label>
                                                <input type="radio" name="layout_category" value="" <?php checked('', $settings_options['layouts']['category'], true); ?> />
                                                Default
                                            </label>
                                        </div>

                                        <div class="radio">
                                            <label>
                                                <input type="radio" name="layout_category" value="cards" <?php checked('cards', $settings_options['layouts']['category'], true); ?> />
                                                Full Cards
                                            </label>
                                        </div>

                                        <hr class="divider">

                                        <h2><?= _e('Shopping Cart Page', 'dtcmc'); ?></h2>
                                        <label class="text-semibold">Layout Type</label>
                                        <div class="radio">
                                            <label>
                                                <input type="radio" name="layout_cart" value="" <?php checked('', $settings_options['layouts']['cart'], true); ?> />
                                                Default
                                            </label>
                                        </div>

                                        <div class="radio">
                                            <label>
                                                <input type="radio" name="layout_cart" value="list" <?php checked('list', $settings_options['layouts']['cart'], true); ?> />
                                                List
                                            </label>
                                        </div>

                                    </div>

                                    <div class="tab-pane fade" id="tab-analytics">
                                        <h4 class="mb-0"><?= _e('Tracking Code', 'dtcmc'); ?></h4>
                                        <p><?= _e('This will be added just before the closing &lt;/head&gt; tag. Please include the &lt;script&gt; &lt;/script&gt; tag.', 'dtcmc'); ?></p>
                                        
                                        <textarea rows="8" cols="8" class="form-control" name="tracking_code"><?= $settings_options['analytics']; ?></textarea>
                                    </div>

<div class="tab-pane fade" id="tab-custom-code">
<h4 class="mb-0"><?= _e('CSS Style', 'dtcmc'); ?></h4>
<p><?= _e('Add your own CSS style easly. Please do not include the &lt;style&gt; &lt;/style&gt; tag.', 'dtcmc'); ?></p>
<div class="content-group">
<div id="css_editor">
<?= $settings_options['custom_code']['css']; ?>
</div>
</div>
<br>
<h4 class="mb-0"><?= _e('JavaScript', 'dtcmc'); ?></h4>
<p><?= _e('Add your own custom javascript to the footer easly. Please do not include the &lt;script&gt; &lt;/script&gt; tag.', 'dtcmc'); ?></p>
<div class="content-group">
<div id="javascript_editor">
<?= $settings_options['custom_code']['js']; ?>
</div>
</div>
</div>
                                </div>

                            </div>
                        </form>

                    </div>
                </div>

            </div>
        </div>

    </div>
</div>