<?php
/*
Plugin Name: mCommerce
Plugin URI: http://mcommerce.danthecoder.com
Description: The most advance Mobile Solution tailored for WooCommerce, making it easier to sell via mobile online.
Version: 1.0.9
Author: DanTheCoder
Author URI: http://danthecoder.com
*/

if ( ! defined( 'WPINC' ) ) die;
if ( ! class_exists( 'DTC_mCommerce_Core' ) ) die;	

if ( ! defined( 'DTCMC_VERSION' ) ) {
	define( 'DTCMC_VERSION', '1.0.9' );
}

class DTC_mCommerce_Core {

	protected static $instance = null;
	protected $globals;

	protected static $theme_folder_name = 'mcommerce-theme';
	protected static $plugin_name = 'mCommerce';
	protected static $plugin_prefix = 'dtcmc_';
	protected static $plugin_slug = 'dtc-mcommerce';
	protected static $settings_option_key = 'dtcmc_config_settings';
	protected static $core_option_key = 'dtcmc_core_settings';

	protected $plugin_dir;
	protected $plugin_path;
	protected $plugin_url;

	public function __construct() {
		register_activation_hook( __FILE__, array( 'DTC_mCommerce_Core', 'activate' ) );
		register_uninstall_hook( __FILE__, array( 'DTC_mCommerce_Core', 'uninstall' ) );
		//register_deactivation_hook( __FILE__, array( 'DTC_mCommerce_Core', 'deactivate' ) );

		add_filter( 'plugin_action_links', array($this, 'settings_action_links'), 10, 2 );
		add_action( 'setup_theme', array($this, 'load_mcommerce_theme') );
	}

	public static function instance() {
		static $globals;
		if ( self::$instance == null ) {
			self::$instance = new self;
			$globals = self::$instance->set_globals();
			self::$instance->load_includes();
		}
		return $globals;
	}

	public function set_globals() {
		$this->plugin_file = __FILE__;
		$this->plugin_dir = dirname( plugin_basename( $this->plugin_file ) );
		$this->plugin_path = plugin_dir_path( $this->plugin_file );
		$this->plugin_url =	plugin_dir_url( $this->plugin_file );

		$globals = array (
			'theme_folder_name' => self::$theme_folder_name,
			'plugin_name' => self::$plugin_name,
			'plugin_prefix' => self::$plugin_prefix,
			'plugin_slug' => self::$plugin_slug,
			'plugin_dir' => $this->plugin_dir,
			'plugin_path' => $this->plugin_path,
			'plugin_url' => $this->plugin_url,
			'settings_option_key' => self::$settings_option_key,
			'core_option_key' => self::$core_option_key,
		);
		
		$this->globals = $globals;
		return $globals;
	}

	public function load_includes() {
		if ( is_admin() ) {
			include_once( $this->plugin_path . 'admin/class-admin.php' );
			DTC_mCommerce_Admin::instance();
		}

		include_once( $this->plugin_path . 'includes/class-helper.php' );
		DTC_mCommerce_Helper::instance();

		include_once( $this->plugin_path . 'mobile/class-mobile-theme.php' );
		DTC_mCommerce_Mobile::instance();
	}

	public function load_mcommerce_theme() {
		if ( ! is_admin() ) {

			// Check if WooCommerce is active
			if ( class_exists( 'WooCommerce' ) ) {

				include_once( $this->plugin_path . 'includes/class-mobile-detect.php' );
				$dtcmc_detect = new DTC_Mobile_Detect;
				$option = get_option( self::$settings_option_key );

				// Load mCommerce
				if ( $option['enable_mcommerce']) {
					if ( $dtcmc_detect->isMobile() ) {
						add_filter('template', create_function( '$t', 'return "' . self::$theme_folder_name . '";' ) );
						add_filter('stylesheet', create_function( '$s', 'return "' . self::$theme_folder_name . '";' ) );
					}
				}
			}

		}
	}

	public function settings_action_links($links, $file) {
	    static $this_plugin;

	    if (!$this_plugin) {
	        $this_plugin = plugin_basename(__FILE__);
	    }

	    if ($file == $this_plugin) {
	        $settings_link = '<a href="' . get_bloginfo('wpurl') . '/wp-admin/admin.php?page='. self::$plugin_slug .'">Settings</a>';
	        array_unshift($links, $settings_link);
	    }

	    return $links;
	}

	public static function activate() {
		$settings_option_chk = get_option( self::$settings_option_key );
		$core_option_chk = get_option( self::$core_option_key );

		// Are our options saved in the DB? If not save
		if( ! $settings_option_chk ) {
			add_option( self::$settings_option_key, DTC_mCommerce_Helper::settings_default_options() );
		}

		// Set core options
		if( ! $core_option_chk ) {
			add_option( self::$core_option_key, DTC_mCommerce_Helper::core_default_options() );
		}
		
		// Set up the theme file
		WP_Filesystem();
		$unzip_theme = unzip_file( plugin_dir_path( __FILE__ ).'mobile/mcommerce-theme.zip', get_theme_root() );

		if ( $unzip_theme ) {
			unlink( plugin_dir_path( __FILE__ ).'mobile/mcommerce-theme.zip' );
		}

		global $wpdb;

		// Generate API KEY
		$description = 'API key for mCommerce (do not revoke)';
		$permissions = 'read_write';
		$user_id     = get_current_user_id();

		$consumer_key    = 'ck_' . wc_rand_hash();
        $consumer_secret = 'cs_' . wc_rand_hash();

        $data = array(
            'user_id'         => $user_id,
            'description'     => $description,
            'permissions'     => $permissions,
            'consumer_key'    => wc_api_hash( $consumer_key ),
            'consumer_secret' => $consumer_secret,
            'truncated_key'   => substr( $consumer_key, -7 )
        );

        $wpdb->insert(
            $wpdb->prefix . 'woocommerce_api_keys',
            $data,
            array(
                '%d',
                '%s',
                '%s',
                '%s',
                '%s',
                '%s'
            )
        );

        // Write to config file - dirty hack
		$config = include ''.plugin_dir_path( __FILE__ ).'mobile/config.php';
		$config['site_url'] = site_url();
		$config['consumer_key'] = $consumer_key;
		$config['consumer_secret'] = $consumer_secret;
		$config_write = file_put_contents(''.plugin_dir_path( __FILE__ ).'mobile/config.php', '<?php return ' . var_export($config, true) . ';');

		// Update core options	
		$core_option_chk['api_key_id'] = $wpdb->insert_id;
		$core_option_chk['api_consumer_key'] = $consumer_key;
		$core_option_chk['api_consumer_secret'] = $consumer_secret;
		$update_core_options = update_option( self::$core_option_key, $core_option_chk );
	}

	public static function uninstall() {
		$core_option = get_option( self::$core_option_key );

		// Remove the API key
		DTC_mCommerce_Helper::remove_api_key( $core_option['api_key_id'] );

		// Remove the theme files
		DTC_mCommerce_Helper::delete_dir( get_theme_root() . '/'. self::$theme_folder_name );

		// Remove options
		delete_option( self::$core_option_key );

		$settings_option = get_option( self::$settings_option_key );
		if ( $settings_option['general']['force_save'] == FALSE ) {
			delete_option( self::$settings_option_key );
		}
	}

	/*public static function deactivate() {
		DTC_mCommerce_Helper::remove_api_key( $core_option['api_key_id'] );

		// Remove the core files
		//DTC_mCommerce_Helper::delete_dir( get_theme_root() . '/'. self::$theme_folder_name );

		// Remove the theme files
		delete_option( self::$core_option_key );

		$settings_option = get_option( self::$settings_option_key );
		if ( $settings_option['general']['force_save'] == FALSE ) {
			delete_option( self::$settings_option_key );
		}
	}*/


}

DTC_mCommerce_Core::instance();

?>