<?php

if ( ! class_exists( 'WooCommerce_Multilevel_Referal' ) ) {

	/**
	 * Main / front controller class
	 *
	 */
	class WooCommerce_Multilevel_Referal extends WMC_Module {
		protected static $readable_properties  = array();    // These should really be constants, but PHP doesn't allow class constants to be arrays
		protected static $writeable_properties = array();
		protected $modules;

		const VERSION    = '0.1';
		const PREFIX     = 'wmc_';
		const DEBUG_MODE = false;


		/*
		 * Magic methods
		 */

		/**
		 * Constructor
		 *
		 * @mvc Controller
		 */
		protected function __construct() {
			$this->register_hook_callbacks();

			if(is_admin()){
				$this->modules = array(
					'WMR_Settings_General'    	=> WMR_Settings_General::get_instance()
				);
			}
		}


		/*
		 * Static methods
		 */

		/**
		 * Enqueues CSS, JavaScript, etc
		 *
		 * @mvc Controller
		 */
		public static function load_resources() {
			global $wp_scripts;

			wp_register_script(
				self::PREFIX . 'jquery.mask',
				plugins_url( 'js/jquery.mask.js', dirname( __FILE__ ) ),
				array( 'jquery' ),
				self::VERSION,
				true
			);

			wp_register_script(
				self::PREFIX . 'woocommerce-multilevel-referral',
				plugins_url( 'js/woocommerce-multilevel-referral.js', dirname( __FILE__ ) ),
				array( 'jquery' ),
				self::VERSION,
				true
			);
            wp_register_script(
                self::PREFIX . 'sharing-script',
                plugins_url( 'js/share42.js', dirname( __FILE__ ) ),
                array( 'jquery' ),
                self::VERSION,
                true
            );
			wp_register_script(
				self::PREFIX . 'woocommerce-multilevel-referral-admin',
				plugins_url( 'js/woocommerce-multilevel-referral-admin.js', dirname( __FILE__ ) ),
				array( 'jquery', 'jquery-ui-dialog' ),
				self::VERSION,
				true
			);

			wp_register_style(
				self::PREFIX . 'admin',
				plugins_url( 'css/admin.css', dirname( __FILE__ ) ),
				array(),
				self::VERSION,
				'all'
			);

			wp_register_style(
				self::PREFIX . 'front',
				plugins_url( 'css/style.css', dirname( __FILE__ ) ),
				array(),
				self::VERSION,
				'all'
			);

			wp_enqueue_script( self::PREFIX . 'jquery.mask' );

			if ( is_admin() ) {
				// get registered script object for jquery-ui
				$ui = $wp_scripts->query('jquery-ui-core');

				// tell WordPress to load the Smoothness theme from Google CDN
				$protocol = is_ssl() ? 'https' : 'http';
				$url = "$protocol://ajax.googleapis.com/ajax/libs/jqueryui/{$ui->ver}/themes/smoothness/jquery-ui.min.css";
				wp_enqueue_style('jquery-ui-smoothness', $url, false, null);

				wp_enqueue_style( self::PREFIX . 'admin' );
				wp_enqueue_script( self::PREFIX . 'woocommerce-multilevel-referral-admin' );
			} else {
				wp_enqueue_style( self::PREFIX . 'front' );
                wp_enqueue_script( self::PREFIX . 'woocommerce-multilevel-referral' );
				wp_enqueue_script( self::PREFIX . 'sharing-script' );
			}
		}

		/**
		 * Clears caches of content generated by caching plugins like WP Super Cache
		 *
		 * @mvc Model
		 */
		protected static function clear_caching_plugins() {
			// WP Super Cache
			if ( function_exists( 'wp_cache_clear_cache' ) ) {
				wp_cache_clear_cache();
			}

			// W3 Total Cache
			if ( class_exists( 'W3_Plugin_TotalCacheAdmin' ) ) {
				$w3_total_cache = w3_instance( 'W3_Plugin_TotalCacheAdmin' );

				if ( method_exists( $w3_total_cache, 'flush_all' ) ) {
					$w3_total_cache->flush_all();
				}
			}
		}


		/*
		 * Instance methods
		 */

		/**
		 * Prepares sites to use the plugin during single or network-wide activation
		 *
		 * @mvc Controller
		 *
		 * @param bool $network_wide
		 */
		public function activate( $network_wide ) {
        	$obj_referal_program = new Referal_Program();
			$obj_referal_program->create_table();
			$obj_referal_users = new Referal_Users();
			$obj_referal_users->create_table();

			if ( $network_wide && is_multisite() ) {
				$sites = wp_get_sites( array( 'limit' => false ) );

				foreach ( $sites as $site ) {
					switch_to_blog( $site['blog_id'] );
					$this->single_activate( $network_wide );
					restore_current_blog();
				}
			} else {
				$this->single_activate( $network_wide );
			}
            $joining_mail_template = get_option('joining_mail_template');
            $referral_user_template = get_option('referral_user_template');
            $expire_notification_template = get_option('expire_notification_template');
            $jHtml='Hello {first_name} {last_name},<br>
                <br>
Thanks for joining our Referral Program. Your Referral code is�<strong>{referral_code}</strong>. You can share it and earn points on the purchase by your referral users.<br>
Regards,<br>
<br>
Referral Team';
            $rHtml='Hello User,<br><br>
{first_name} {last_name} is invited you to join their referral program. You can join them by [referral_link text="click here"].<br>
<br>
Regards,<br>
<br>
Referral Team.';
            $eHtml='Hello {first_name} {last_name},<br>
<br>
Your Store Reward Credits come with a validity of {validity_period}. You have {available_credits} credits as on {today_date}.�<strong>Redeem your points before they expire.</strong>
<table>
<tbody>
<tr>
<th>Month</th>
<th>Total credits about to expire</th>
<th>Date of expiry</th>
</tr>
<tr>
<td>{expire_month}</td>
<td>{expire_credits}</td>
<td>{expire_date}</td>
</tr>
</tbody>
</table>';

            if($joining_mail_template!==false){
                add_option('joining_mail_template',addslashes($jHtml));
            }else if(stripslashes($joining_mail_template)==''){
                update_option('joining_mail_template',addslashes($jHtml));
            }
            if($referral_user_template!==false){
                add_option('referral_user_template',addslashes($rHtml));
            }else if(stripslashes($referral_user_template)==''){
                update_option('referral_user_template',addslashes($rHtml));
            }
            if($expire_notification_template!==false){
			    add_option('expire_notification_template',addslashes($eHtml));
            }else if(stripslashes($expire_notification_template)==''){
                update_option('expire_notification_template',addslashes($eHtml));
            }

             $this->wmcCreatePreBanners();
		}

		/**
		 * Runs activation code on a new WPMS site when it's created
		 *
		 * @mvc Controller
		 *
		 * @param int $blog_id
		 */
		public function activate_new_site( $blog_id ) {
			switch_to_blog( $blog_id );
			$this->single_activate( true );
			restore_current_blog();
		}

		/**
		 * Prepares a single blog to use the plugin
		 *
		 * @mvc Controller
		 *
		 * @param bool $network_wide
		 */
		protected function single_activate( $network_wide ) {
			foreach ( $this->modules as $module ) {
				$module->activate( $network_wide );
			}

			flush_rewrite_rules();
		}

		/**
		 * Rolls back activation procedures when de-activating the plugin
		 *
		 * @mvc Controller
		 */
		public function deactivate() {
			foreach ( $this->modules as $module ) {
				$module->deactivate();
			}

			flush_rewrite_rules();
		}

		/**
		 * Register callbacks for actions and filters
		 *
		 * @mvc Controller
		 */
		public function register_hook_callbacks() {
			if(is_admin()){
				WMR_Settings_General::get_instance();
				WMR_User::get_instance();
				WMR_Referal_Settings::get_instance();

				add_action( 'pre_user_query',	array( $this, 'in_active_user' ) );
			}

			//Referal_Users::get_instance();

			add_action( 'wpmu_new_blog',         __CLASS__ . '::activate_new_site' );
			add_action( 'wp_enqueue_scripts',    __CLASS__ . '::load_resources', 99 );
			add_action( 'admin_enqueue_scripts', __CLASS__ . '::load_resources' );

			add_action( 'init',                  array( $this, 'init' ) );
			add_action( 'init',                  array( $this, 'upgrade' ), 11 );

			//add_action( 'wmc_joining_user_notification',	array( $this, 'wmc_joining_mail' ), 10, 6);
			add_filter( 'woocommerce_email_classes', 		array( $this, 'wmc_referral_join_email' ) );
			add_action( 'woocommerce_email', 				array( $this, 'wmc_custom_mail_handler' ) );
			//add_action('wp', function(){ echo '<pre>';print_r($GLOBALS['wp_filter']); echo '</pre>';exit; } );
		}

		/**
		 * Initializes variables
		 *
		 * @mvc Controller
		 */

		public function init() {
			try {
				if( is_admin() ){
					if( isset($_GET['load_referral_user_list']) ){
						$obj_referal_program = new Referal_Program();
						$referral_users = $obj_referal_program->get_referral_user_list(sanitize_text_field($_GET['load_referral_user_list']) );
						echo self::render_template( 'admin/referral_list_popup.php', array('referral_users' => $referral_users) );
						die();
					}
					if( isset($_GET['remove_referral_user']) ){
						$obj_referal_program = new Referal_Program();
						$parent_referral_user = $obj_referal_program->remove_referral_user( sanitize_text_field($_GET['remove_referral_user']) );
						$referral_users = $obj_referal_program->get_referral_user_list( $parent_referral_user );
						echo self::render_template( 'admin/referral_list_popup.php', array('referral_users' => $referral_users) );
						die();
					}
					if( isset($_GET['active_referral_user']) ){
						$obj_referal_users = new Referal_Users();
						$parent_referral_user = $obj_referal_users->active_referral_user( sanitize_text_field($_GET['active_referral_user']) );
						die();
					}
				}
			} catch ( Exception $exception ) {
				add_notice( __METHOD__ . ' error: ' . $exception->getMessage(), 'error' );
			}
            /*$this->registerCustomPostType( 'Banner', 'Banners', 'wmc-banner',  array( 'title', 'thumbnail', 'excerpt') );
            add_filter('manage_wmc-banner_posts_columns', __CLASS__.'::fnAddBannerColumn');
            add_filter('manage_edit-wmc-banner_columns', __CLASS__.'::fnEditBannerColumn',10,2);
            add_filter('manage_wmc-banner_posts_custom_column', __CLASS__.'::fnManageBannerColumn', 10, 2);
            add_action('edit_form_top', __CLASS__.'::fnAddAllBannerButton',11,1);
            add_action('trashed_post', __CLASS__.'::fnBeforeDeleteBanner');
            add_filter( 'post_row_actions', __CLASS__.'::remove_banner_row_actions', 10, 2 );
            add_filter( 'bulk_actions-edit-wmc-banner', __CLASS__.'::banner_bulk_actions' );
            $error=get_transient( 'banner_delete_error' );
            if($error!=''){
                add_action('admin_notices', function() use ( $error ){echo '<div class="notice notice-error is-dismissible" ><p>'.$error.'</p></div>';  },11);
                delete_transient( 'banner_delete_error' );
            }*/
		}
        /* Banner Module functions */
        function wmcCreatePreBanners(){
            $allBanners=$this->wmcScandir(WMC_DIR.'images/banners');
            $arrPreBanners=array();
            if(is_array($allBanners) && count($allBanners)>0){
                foreach($allBanners as $name=>$fullpath){
                    $bannerId='';
                    $filename = basename($fullpath);
                    $filetype = wp_check_filetype($fullpath);
                    if($filetype['type']=='image/jpeg' || $filetype['type']=='image/png'){
                        $title = pathinfo($filename, PATHINFO_FILENAME);
                        $description= __('This is the promotional banner','wmc');
                        $arrFile=array('name'=>$filename,'tmp_name'=>$fullpath,'type'=>$filetype['type'],'size'=>filesize($fullpath));
                        $banner=get_page_by_title($title,OBJECT,'wmc-banner');
                        if(!$banner){
                            $bannerId = wp_insert_post(array('post_title' =>$title,'post_type' =>'wmc-banner','post_excerpt'=>$description,'post_status' => 'publish'));

                        }else{
                            $bannerId = $banner->ID;
                        }
                        if($bannerId!=''){
                            if(!has_post_thumbnail($bannerId)) {
                                $attachID=$this->wmcBannerUpload($bannerId,$arrFile);
                                if($attachID!=0){
                                    set_post_thumbnail( $bannerId, $attachID );
                                }
                            }
                            array_push($arrPreBanners,$bannerId);
                        }
                    }
                    if(is_array($arrPreBanners) && count($arrPreBanners)>0){
                        update_option('wmc-pre-banners',$arrPreBanners,true);
                    }
                }
            }
        }
        function wmcBannerUpload($postID,$fileArray){
            if ( !function_exists('media_handle_upload') ) {
                require_once(ABSPATH . "wp-admin" . '/includes/image.php');
                require_once(ABSPATH . "wp-admin" . '/includes/file.php');
                require_once(ABSPATH . "wp-admin" . '/includes/media.php');
            }
            $id = media_handle_sideload( $fileArray, $postID );
            if ( !is_wp_error($id) ) {
                return $id;
            }
            return 0;
        }
        static function banner_bulk_actions( $actions ){
            unset( $actions[ 'trash' ] );
            return $actions;
        }
        static function fnBeforeDeleteBanner($post_id){
             global $post_type;
             if ( $post_type == 'wmc-banner' ){
                 $arrBanners=get_option('wmc-pre-banners');
                    if(is_array($arrBanners) && count($arrBanners)>0){
                        if(in_array($post->ID,$arrBanners)){
                             wp_untrash_post($post_id);
                             set_transient( 'banner_delete_error', 'You can not delete pre-defined banners', 1000 );
                        }
                    }
                 return;
             }
        }
        static function remove_banner_row_actions($actions, $post ){
            if( get_post_type() === 'wmc-banner' ){
                $arrBanners=get_option('wmc-pre-banners');
                if(is_array($arrBanners) && count($arrBanners)>0){
                    if(in_array($post->ID,$arrBanners)){
                        unset( $actions['trash'] );
                    }
                }
                return $actions;
            }
        }
        static function fnAddAllBannerButton($post){
            if ( 'wmc-banner' == $post->post_type ){
                echo ' <a href="' . esc_url( admin_url( 'edit.php?post_type=wmc-banner' ) ) . '" class="add-new-h2">'.__('All Banners','wmc').'</a>';
            }
        }
        static function fnAddBannerColumn($columns){
             $columns['img'] = 'Banner';
             return $columns;
        }

        static function fnManageBannerColumn($column_name, $post_id){
            if( $column_name == 'img' ) {
                echo get_the_post_thumbnail($post_id, 'medium');
            }
        }
         /* Banner Module functions End */
		/*
		 *	Add additnal resticriction on user list
		 */
		public function in_active_user( $query ) {
			global $wpdb;
			$where = '';
			if( isset( $_GET['page'] ) && $_GET['page'] == 'wc_referral' ){
				$query->query_from = $query->query_from . ' JOIN '.$wpdb->prefix.'referal_users AS ru ON ru.user_id = '.$wpdb->prefix.'users.ID ';
				$where = $query->query_where . ' AND ru.active = 1 ';
			}
			if ( isset( $_GET['user_status'] ) && '0' == $_GET['user_status'] ) {
				$query->query_fields = $query->query_fields. ', ru.update_date ';
				$where = $query->query_where . ' AND ru.active = 0 ';

				if( isset( $_REQUEST['orderby'] ) && $_REQUEST['orderby'] == 'deactivate_date' ){
					$query->query_orderby = 'ORDER BY ru.update_date '.esc_sql($_REQUEST['order']);
				}
			}
			if( $where ){
				$query->query_where = $where;
			}
			return $query;
		}

		/**
		 *	Add email settings to WooCommerce Email settings page.
		 *
		 *	@param array $email_classes List of register email settings
		 *
		 *	@return array Return new array list.
		 **/

		public function wmc_referral_join_email( $email_classes ) {

			// include our custom email class
			require_once( __DIR__ . '/referral-mail.php' );

			// add the email class to the list of email classes that WooCommerce loads
			$email_classes['WMC_Joining_User'] = new Referral_Mail();

			return $email_classes;

		}

		function wmc_custom_mail_handler( $emails_obj ) {
			add_action( 'wmc_joining_user_notification', array( $emails_obj->emails['WMC_Joining_User'], 'trigger' ), 10, 6 );
			add_action( 'wmc_user_reminder', array( $emails_obj->emails['WMC_Joining_User'], 'reminder' ), 10, 9 );
		}

		/**
		 *	Sending mail for new activated user.
		 *
		 *	@param int $to Email id of user
		 *	@param string $first_name User's first name
		 *	@param string $last_name User's last name
		 *	@param string $code New generated referral code for new user
		 *	@param string $template Email tempate base on user
		 *	@param int $user_id Parent user id
		 *
		 *	@return void
		 **/
		public function wmc_joining_mail($to, $first_name, $last_name, $code, $template, $user_id){
			//wp_mail( 'mitesh@prismitsolutions.com', 'Call', 1 );
			$obj_mails = new WC_Emails();
			$email = $obj_mails->emails['WMC_Joining_User'];
			$email->trigger( $to, $first_name, $last_name, $code, $template,  $user_id );
		}

		/**
		 * Checks if the plugin was recently updated and upgrades if necessary
		 *
		 * @mvc Controller
		 *
		 * @param string $db_version
		 */
		public function upgrade( $db_version = 0 ) {
			/*
			if ( version_compare( $this->modules['WMC_Settings']->settings['db-version'], self::VERSION, '==' ) ) {
				return;
			}

			foreach ( $this->modules as $module ) {
				$module->upgrade( $this->modules['WMC_Settings']->settings['db-version'] );
			}

			$this->modules['WMC_Settings']->settings = array( 'db-version' => self::VERSION );
			*/
			self::clear_caching_plugins();
		}

		/**
		 * Checks that the object is in a correct state
		 *
		 * @mvc Model
		 *
		 * @param string $property An individual property to check, or 'all' to check all of them
		 * @return bool
		 */
		protected function is_valid( $property = 'all' ) {
			return true;
		}
        function registerCustomPostType( $title, $title_p, $name, $supports, $isShow=false ){
            $labels = array(
                'name' => _x( "$title_p", 'post type general name' ),
                'singular_name' => _x( "$title", 'post type singular name' ),
                'add_new' => _x( "Add New $title", "$title" ),
                'add_new_item' => __( "Add New $title" ),
                'edit_item' => __( "Edit $title" ),
                'new_item' => __( "New $title" ),
                'view_item' => __( "View $title" ),
                'search_items' => __( "Search $title" ),
                'not_found' => __( "No $title found" ),
                'not_found_in_trash' => __( "No $title found in Trash" ),
                'parent_item_colon' => '',
                'menu_name' => "$title_p"
            );
            $args = array(
                'labels' => $labels,
                'public' => true,
                'show_in_menu' => $isShow,
                'show_in_nav_menus' => true,
                'publicly_queryable' => true,
                'query_var' => true,
                'rewrite' => true,
                'capability_type' => 'post',
                'has_archive' => false,
                'hierarchical' => false,
                'exclude_from_search' => false,
                'supports' => $supports
            );

            register_post_type($name, $args);
            return $name;
        }
        /* function to sacn files in the directory */
        function wmcScandir( $path, $extensions = null, $depth = 0, $relative_path = '' ) {
            if ( ! is_dir( $path ) )
                return false;

            if ( $extensions ) {
                $extensions = (array) $extensions;
                $_extensions = implode( '|', $extensions );
            }

            $relative_path = trailingslashit( $relative_path );
            if ( '/' == $relative_path )
                $relative_path = '';

            $results = scandir( $path );
            $files = array();

            foreach ( $results as $result ) {
                if ( '.' == $result[0] )
                    continue;
                if ( is_dir( $path . '/' . $result ) ) {
                    if ( ! $depth || 'CVS' == $result )
                        continue;
                    $found = $this->wmcScandir( $path . '/' . $result, $extensions, $depth - 1 , $relative_path . $result );
                    $files = array_merge_recursive( $files, $found );
                } elseif ( ! $extensions || preg_match( '~\.(' . $_extensions . ')$~', $result ) ) {
                    $files[ $relative_path . $result ] = $path . '/' . $result;
                }
            }

            return $files;
        }
	} // end WooCommerce_Multilevel_Referal
}
