<?php 
	global $dtcwm_settings_config, $dtcwm_device_detect; 
	$favicon = $dtcwm_settings_config['favicon']['url'].''.$dtcwm_settings_config['favicon']['name'];
?>
<html ng-app="dtcwmApp" <?php language_attributes(); ?>>
    <head>

	    <meta charset="utf-8">
	    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, user-scalable=no, minimal-ui">
	    
	    <meta name="theme-color" content="<?= $dtcwm_settings_config['color_scheme']['address_bar']; ?>">
		<meta name="msapplication-navbutton-color" content="<?= $dtcwm_settings_config['color_scheme']['address_bar']; ?>">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">  
		
	    <meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">  
		<?php if ( $dtcwm_settings_config['favicon']['win_tile'] ); { ?>
		<meta name="msapplication-TileColor" content="<?= $dtcwm_settings_config['favicon']['win_tile']; ?>">
		<?php } ?>
		<?php if ( $favicon ); { ?>
		<meta name="msapplication-TileImage" content="<?= $favicon; ?>-144x144.png">
		<?php } ?>

	    <title><?= $dtcwm_settings_config['site_title']; ?> - <?= get_bloginfo('description'); ?></title>

		<?php if ( $favicon ) { ?>	
		<link rel="apple-touch-icon" sizes="57x57" href="<?= $favicon; ?>-57x57.png">
		<link rel="apple-touch-icon" sizes="60x60" href="<?= $favicon; ?>-60x60.png">
		<link rel="apple-touch-icon" sizes="72x72" href="<?= $favicon; ?>-72x72.png">
		<link rel="apple-touch-icon" sizes="76x76" href="<?= $favicon; ?>-76x76.png">
		<link rel="apple-touch-icon" sizes="114x114" href="<?= $favicon; ?>-114x114.png">
		<link rel="apple-touch-icon" sizes="120x120" href="<?= $favicon; ?>-120x120.png">
		<link rel="apple-touch-icon" sizes="144x144" href="<?= $favicon; ?>-144x144.png">
		<link rel="apple-touch-icon" sizes="152x152" href="<?= $favicon; ?>-152x152.png">
		<link rel="apple-touch-icon" sizes="180x180" href="<?= $favicon; ?>-180x180.png">

		<link rel="icon" type="image/png" sizes="192x192" href="<?= $favicon; ?>-192x192.png">
		<link rel="icon" type="image/png" sizes="32x32" href="<?= $favicon; ?>-32x32.png">
		<link rel="icon" type="image/png" sizes="96x96" href="<?= $favicon; ?>-96x96.png">
		<link rel="icon" type="image/png" sizes="16x16" href="<?= $favicon; ?>-16x16.png">
		<?php } ?>

	    <?php wp_head(); ?>
    </head>
    <body ng-controller="MainCtrl">

    	<?php get_template_part( 'layouts/sidepanel', $dtcwm_settings_config['layouts']['sidepanel'] ); ?>

		<!-- Views Wrap -->
		<div class="views">
		    <div class="view view-main">

				<div class="pages navbar-fixed <?php if ( true == dtcwm_nav_layout_check( 'bottombar' )) echo 'toolbar-fixed'; ?>">

				    <?php
				    	get_template_part( 'layouts/home', $dtcwm_settings_config['layouts']['home'] );
					    get_template_part( 'layouts/catalog', $dtcwm_settings_config['layouts']['catalog'] );
						get_template_part( 'layouts/search', $dtcwm_settings_config['layouts']['search'] );
						get_template_part( 'layouts/category', $dtcwm_settings_config['layouts']['category'] );
						get_template_part( 'layouts/cart', $dtcwm_settings_config['layouts']['cart'] );
						get_template_part( 'layouts/view_product', $dtcwm_settings_config['layouts']['view_product'] );
					?>