<?php
/**
 * Custom styling from color scheme 
 * and also custom CSS option
 *-------------------------------------------- */
if ( ! defined( 'ABSPATH' ) )
    exit;

function dtcwm_custom_css() {
	$settings_options = get_option( 'dtcwm_config_settings' );
	$color = $settings_options['color_scheme'];

ob_start();
?>

<style id="dtcwm-custom-css" type="text/css">

<?php if( $color['body_bg_color'] ) { ?>
.page {background: <?= $color['body_bg_color']; ?>}
<?php } ?>

<?php if( $color['link_color'] ) { ?>
a,
.modal-button, 
.modal-buttons .button {
	color: <?= $color['link_color']; ?>
}
<?php } ?>


<?php if( $color['primary_color'] ) { ?>
label.label-radio input[type=checkbox]:checked+.item-media i.icon-form-radio, label.label-radio input[type=checkbox]:checked~.item-after i.icon-form-radio, label.label-radio input[type=checkbox]:checked~.item-inner i.icon-form-radio, label.label-radio input[type=radio]:checked+.item-media i.icon-form-radio, label.label-radio input[type=radio]:checked~.item-after i.icon-form-radio, label.label-radio input[type=radio]:checked~.item-inner i.icon-form-radio {
    border-color: <?= $color['primary_color']; ?>;
}

label.label-radio input[type=checkbox]:checked+.item-media i.icon-form-radio:after, label.label-radio input[type=checkbox]:checked~.item-after i.icon-form-radio:after, label.label-radio input[type=checkbox]:checked~.item-inner i.icon-form-radio:after, label.label-radio input[type=radio]:checked+.item-media i.icon-form-radio:after, label.label-radio input[type=radio]:checked~.item-after i.icon-form-radio:after, label.label-radio input[type=radio]:checked~.item-inner i.icon-form-radio:after {
    background-color: <?= $color['primary_color']; ?>;
}

.theme-color-text {
	color: <?= $color['primary_color']; ?> !important;
}

.list-block .focus-state .floating-label, 
.list-block .focus-state .label,
.ios .navbar-inner i.icon, 
.ios .subnavbar i.icon,
.ios .navbar .searchbar i.icon,
.tabbar a.tab-link.active, 
.tabbar a.tab-link.active-state, 
html:not(.watch-active-state) .tabbar a.tab-link:active,
.tabbar a.tab-link  {
	color: <?= $color['primary_color']; ?>;
}

.label-switch input[type=checkbox]:checked+.checkbox,
.label-switch input[type=checkbox]:checked+.checkbox:after,
.swiper-pagination-bullet-active,
.tabbar .tab-link-highlight {
	background: <?= $color['primary_color']; ?>;
}

.theme-color-bg {
    background-color: <?= $color['primary_color']; ?>;
}

.ios label.label-radio input[type=checkbox]:checked~.item-inner, 
.ios label.label-radio input[type=radio]:checked~.item-inner {
	background-image:url("data:image/svg+xml;charset=utf-8,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20viewBox%3D'0%200%2013%2010'%3E%3Cpolygon%20fill%3D'<?= $color['primary_color']; ?>'%20points%3D'11.6%2C0%204.4%2C7.2%201.4%2C4.2%200%2C5.6%204.4%2C10%204.4%2C10%204.4%2C10%2013%2C1.4%20'%2F%3E%3C%2Fsvg%3E");
}

.ios .label-switch .checkbox:after {
    background: #fff !important;
}

.focus-state .input-field:after, 
.focus-state .item-input-field:after, 
.input-field.focus-state:after, 
.input-field.not-empty-state:after, 
.item-input-field.focus-state:after, 
.item-input-field.not-empty-state:after, 
.not-empty-state .input-field:after, 
.not-empty-state .item-input-field:after {
    background: <?= $color['primary_color']; ?>;
}

.subnavbar .buttons-row .button {
    border-color: <?= $color['primary_color']; ?>;
    color: <?= $color['primary_color']; ?>;
}

.subnavbar .buttons-row .button.active {
    background: <?= $color['primary_color']; ?>;
    color: #fff;
}

<?php } ?>



<?php if( $color['button_bg_color'] ) { ?>
.button.button-fill.active-state, 
html:not(.watch-active-state) .button.button-fill:active,
.button.button-fill {
	background: <?= $color['button_bg_color']; ?>
}
.button {
    color: <?= $color['button_bg_color']; ?>;
}
.ios .button {
    border-color: <?= $color['button_bg_color']; ?>;
}
<?php } ?>

<?php if( $color['button_text_color'] ) { ?>
.button.button-fill {color: <?= $color['button_text_color']; ?>}
<?php } ?>




<?php if( $color['navbar_bg_color'] ) { ?>
.navbar,
.picker-modal .toolbar {
	background: <?= $color['navbar_bg_color']; ?> !important; 
}
<?php } ?>

<?php if( $color['navbar_text_color'] ) { ?>
.navbar,
.navbar-inner .icon,
.navbar a.link,
.picker-modal .toolbar a.link {
    color: <?= $color['navbar_text_color']; ?> !important;
}
<?php } ?>


<?php if( $color['cart_badge_bg_color'] ) { ?>
.navbar .cart-badge {
	color: <?= $color['cart_badge_text_color']; ?> !important;
    background: <?= $color['cart_badge_bg_color']; ?> !important;
}
<?php } ?>


<?php if( $color['label_bg_color'] ) { ?>
.sale-label {
	color: <?= $color['label_text_color']; ?> !important;
    background: <?= $color['label_bg_color']; ?> !important;
}
<?php } ?>

<?php
    if ( $settings_options['custom_code']['css'] ) {
        echo $settings_options['custom_code']['css'];
    }
?>
</style>

<?php
$buffer = ob_get_clean();
echo dtcwm_minify_css( $buffer );
}
add_action( 'wp_head', 'dtcwm_custom_css', 100 );