<?php
/**
 * Gloablly used functions
 *-------------------------------------------- */
if ( ! defined( 'ABSPATH' ) )
    exit;

/**
 * Add WooCommerce to the theme
 *-------------------------------------------- */
function dtcwm_woocommerce_support() {
    add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'dtcwm_woocommerce_support' );



/**
 * Enqueue CSS & JS files
 *-------------------------------------------- */
function dtcwm_add_assets() {
	global $dtcwm_device_detect, $dtcwm_settings_config;

	if( $dtcwm_device_detect->isiOS() ) {
		wp_enqueue_style( 'dtcwm-ios-core', get_template_directory_uri() . '/assets/css/core-ios.min.css', '', '', 'screen' );
	} else {
		wp_enqueue_style( 'dtcwm-android-core', get_template_directory_uri() . '/assets/css/core-android.min.css', '', '', 'screen' );
	}
	wp_enqueue_style( 'dtcwm-main-css', get_template_directory_uri() . '/assets/css/mcommerce.css', '', '', 'screen' );

 	wp_enqueue_script( 'dtcwm-core-js', get_template_directory_uri() . '/assets/js/core.min.js', '', false, true );
 	wp_enqueue_script( 'dtcwm-aj-js', get_template_directory_uri() . '/assets/js/angular.min.js', '', false, true );
 	wp_enqueue_script( 'dtcwm-app-js', get_template_directory_uri() . '/assets/js/app-config.js', '', false, true );
 	wp_enqueue_script( 'dtcwm-serv-js', get_template_directory_uri() . '/assets/js/services.js', '', false, true );
 	wp_enqueue_script( 'dtcwm-ctrl-js', get_template_directory_uri() . '/assets/js/controllers.js', '', false, true );

	wp_localize_script( 'dtcwm-app-js', 'dtcwm_vars', array(
	    'wpAjaxURL' => admin_url( 'admin-ajax.php' ),
	    'siteTitle' => $dtcwm_settings_config['site_title'],
	    'siteURL' => get_site_url(),
	    'dtcwm_product_nonce' => wp_create_nonce('dtcwm_product_nonce'),
	    'dtcwm_cart_nonce' => wp_create_nonce('dtcwm_cart_nonce'),
	    'dtcwm_auth_nonce' => wp_create_nonce('dtcwm_auth_nonce')
	) );
}
add_action( 'wp_enqueue_scripts', 'dtcwm_add_assets' );



/**
 * Remove all unnecessary JS and CSS files
 *-------------------------------------------- */
function dtcwm_script_cleaner() {
	// Scripts
	wp_dequeue_script( 'prettyPhoto' );
	wp_dequeue_script( 'prettyPhoto-init' );
	wp_dequeue_script( 'wc-add-to-cart' );
	wp_dequeue_script( 'woocommerce' );
	wp_dequeue_script( 'wc-cart-fragments' );
	wp_dequeue_script( 'wc-single-product' );
	//wp_deregister_script('jquery');

	// Styles
	wp_dequeue_style( 'select2' );
	wp_dequeue_style( 'woocommerce_frontend_styles' );
	wp_dequeue_style( 'woocommerce-general');
	wp_dequeue_style( 'woocommerce-smallscreen' );
	wp_dequeue_style( 'woocommerce-layout' );
	wp_dequeue_style( 'woocommerce_prettyPhoto_css' );
}
add_action( 'wp_enqueue_scripts', 'dtcwm_script_cleaner', 100 );



/**
 * Remove junk from WordPress head
 *-------------------------------------------- */
function dtcwm_head_cleanup() {
 	remove_action( 'wp_head', 'rsd_link' );
    remove_action( 'wp_head', 'wp_generator' );

    remove_action( 'wp_head', 'feed_links', 2 );
    remove_action( 'wp_head', 'feed_links_extra', 3 );

    remove_action( 'wp_head', 'index_rel_link' );
    remove_action( 'wp_head', 'wlwmanifest_link' );

    remove_action( 'wp_head', 'start_post_rel_link', 10, 0 );
    remove_action( 'wp_head', 'parent_post_rel_link', 10, 0 );
    remove_action( 'wp_head', 'adjacent_posts_rel_link', 10, 0 );
    remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0 );

    remove_action( 'wp_head', 'wp_shortlink_wp_head', 10, 0 );
    remove_action( 'wp_head', 'rel_canonical' );
	remove_action( 'wp_head', 'rest_output_link_wp_head', 10 );

	// emoji 
	remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
	remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
	remove_action( 'wp_print_styles', 'print_emoji_styles' );
	remove_action( 'admin_print_styles', 'print_emoji_styles' );

	// Embeds
	remove_action( 'rest_api_init', 'wp_oembed_register_route' );
    remove_filter( 'oembed_dataparse', 'wp_filter_oembed_result', 10 );
    remove_action( 'wp_head', 'wp_oembed_add_discovery_links' );
    remove_action( 'wp_head', 'wp_oembed_add_host_js' );
}
add_action( 'after_setup_theme', 'dtcwm_head_cleanup' );