<?php
/**
 * Helpers re-useable functions
 *-------------------------------------------- */
if ( ! defined( 'ABSPATH' ) )
    exit;

// Clean and minify customm css
function dtcwm_minify_css( $css ) {
	$css = str_replace( array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $css );
	return $css;
}


// Load the Navigation layout type
function dtcwm_nav_layout_check( $type ) {
	global $dtcwm_settings_config, $dtcwm_device_detect;

    if ( $dtcwm_device_detect->isAndroidOS() && $dtcwm_settings_config['layouts']['android_navigation'] == $type ) { 
        return true;
    } else if ( $dtcwm_device_detect->isiOS() && $dtcwm_settings_config['layouts']['ios_navigation'] == $type ) { 
        return true;
    } else if ( !$dtcwm_device_detect->isAndroidOS() && !$dtcwm_device_detect->isiOS() && $dtcwm_settings_config['layouts']['android_navigation'] == $type ) {
        return true;
    } else {
    	return false;
    }
}