<?php 
if ( ! defined( 'ABSPATH' ) )
    exit;

global $dtcwm_settings_config; 
?>

<div ng-controller="CartCtrl" data-page="cart" id="page-cart" class="page cached">
    
    <div class="navbar navbar-shadow">
        <div class="navbar-inner">
            <div class="left">
                <a href="#" class="back link icon-only">
                    <i class="icon {{deviceIos ? 'wm-ios-arrow-left' : 'wm-android-arrow-left'}}"></i>
                </a>
            </div>

            <div class="center sliding"><span class="title">My Cart</span></div>

            <div class="right">
                <a href="#" ng-click="emptyCart()" class="link icon-only" ng-click-once>
                    <i class="icon {{deviceIos ? 'wm-ios-trash' : 'wm-android-trash'}}"></i>
                </a>
            </div>
        </div>
    </div>

    <div ng-if="cartItems" class="toolbar toolbar-bottom toolbar-action toolbar-shadow">
        <div class="toolbar-inner">

            <div class="row">
                <div class="col-40">
                    Total: <span ng-bind-html="cartTotals.order_total | sanitize"></span>
                </div>
                <div class="col-60">
                    <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="button button-block button-raised button-fill external">Proceed to Checkout</a>
                </div>
            </div>

        </div>
    </div>

    <div class="page-content pull-to-refresh-content" data-ptr-distance="60">

        <?php 
        get_template_part( 'contents/content', 'pull_refresh' );
        get_template_part( 'contents/content', 'preloader' );
        get_template_part( 'contents/content', 'error_response' );
        ?>

        <div ng-if="cartItems" class="cart-items product-list">
            <div class="list-block media-list">
                <ul>
                    <li ng-repeat="item in cartItems" id="{{item.cart_item_key}}" class="swipeout">
                        <div class="swipeout-content">
                            <div class="item-content">

                                <div class="item-media" ng-bind-html="item.thumbnail | sanitize"></div>
                                    <div class="item-inner">
                                        <div class="item-title-row">
                                            <div class="item-title" ng-bind-html="item.title | sanitize"></div>
                                        </div>

                                        <div class="detail-wrap row">
                                            <div class="col-35">
                                                <div class="quantity-box">
                                                    <div class="item-title label">Qty</div>
                                                    <div class="item-input item-input-field">
                                                        <input id="product-{{item.product_id}}" ng-click="updateQuantity(item.product_id, item.cart_item_key)" type="text" value="{{item.quantity}}" readonly="readonly"/>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-65">
                                                <div class="detial-prices">
                                                    Price: <span ng-bind-html="item.unit_price | sanitize"></span>
                                                    <br>
                                                    Total: <span ng-bind-html="item.total_price | sanitize"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        <div class="swipeout-actions-right">
                            <a href="#" ng-click="removeItem(item.cart_item_key)" class="remove-swipeout" ng-click-once>Remove</a>
                        </div>
                    </li>
                </ul>
            </div>
        </div>

        <div class="hidden not-found">
            <div class="content-block text-center">
                <div class="empty-icon">
                    <i class="icon {{deviceIos ? 'wm-ios-cart' : 'wm-android-cart'}}"></i>
                </div>
                <h2>Your cart is empty</h2>
                <p>but doesn't have to be.</p>
                <a href="#category" class="button button-big button-fill button-round button-raised">Start Shopping</a>
            </div>
        </div>

    </div>

</div>