<?php 
if ( ! defined( 'ABSPATH' ) ) 
	exit;

global $dtcwm_settings_config, $dtcwm_device_detect; 
?>

<div ng-controller="CategoryCtrl" data-page="category" id="page-category" class="page cached">

	<div class="navbar">
		<div class="navbar-inner navbar-shadow">
		    
		    <div class="left">
		        <?php if ( true == dtcwm_nav_layout_check( 'sidepanel' ) ) { ?>
		        <a href="#" class="link icon-only open-panel">
		            <i class="icon {{deviceIos ? 'wm-ios-menu' : 'wm-android-menu'}}"></i>
		        </a>
		        <?php } ?>
		    </div>

		    <div class="center sliding"><span class="title">All Categories</span></div>
		    
		    <div class="right">
		        <?php if ( $dtcwm_device_detect->isAndroidOS() ) { ?>
		        <a ng-if="deviceAndroid" href="#search" class="link icon-only">
		            <i class="icon {{deviceIos ? 'wm-ios-search' : 'wm-android-search'}}"></i>
		        </a>
		        <?php } ?>

		        <a href="#cart" class="link icon-only">
		            <span class="cart-badge" ng-bind="cartTotalShow"></span>
		            <i class="icon {{deviceIos ? 'wm-ios-cart' : 'wm-android-cart'}}"></i>
		        </a>
		    </div>
		    
		</div>
	</div>
    
    <?php get_template_part( 'layouts/bottombar', $dtcwm_settings_config['layouts']['bottombar'] ); ?>
    
	<div class="page-content">
		<?php
	        $taxonomy = 'product_cat';
	        $orderby = 'name';  
	        $show_count = 1;
	        $pad_counts = 1;
	        $hierarchical = 1;
	        $title = '';  
	        $empty = 0;

	        $cat_args = array(
	            'taxonomy'     => $taxonomy,
	            'orderby'      => $orderby,
	            'show_count'   => $show_count,
	            'pad_counts'   => $pad_counts,
	            'hierarchical' => $hierarchical,
	            'title_li'     => $title,
	            'hide_empty'   => $empty
	        );

	        $categories_list = get_categories( $cat_args );
	    ?>

	    <?php if ( $categories_list ) { ?>

        	<?php foreach ($categories_list as $category) {
                $sub_cat_args = array(
                    'taxonomy'     => $taxonomy,
                    'child_of'     => 0,
                    'parent'       => $category->term_id,
                    'orderby'      => $orderby,
                    'show_count'   => $show_count,
                    'pad_counts'   => $pad_counts,
                    'hierarchical' => $hierarchical,
                    'title_li'     => $title,
                    'hide_empty'   => $empty
                );
                $sub_category_list = get_categories( $sub_cat_args );

                $category_thumbnail_id = get_woocommerce_term_meta($category->term_id, 'thumbnail_id', true);
				$category_image = wp_get_attachment_url($category_thumbnail_id);
            ?>
            <a ng-click="setCategory('<?= $category->name; ?>', '<?= $category->slug; ?>')" href="#catalog">
			<div class="card theme-color-bg category-cards" style="background-image:url(<?= esc_url($category_image); ?>);">
				<div class="card-title"><?= $category->name; ?></div>
				<div class="card-subtitle"><?= $category->count; ?> Products</div>
			</div>
			</a>
			<?php } ?>

		<?php } else { ?>
	        <div class="blank-state">
	            <div class="content-block text-center">
	                <div class="empty-icon">
	                    <i class="icon wm-empty-info"></i>
	                </div>
	                <h2>No Categories Found</h2>
	                <p>Why not browse the catalog?</p>
	                <a href="#catalog" class="button button-big button-fill button-round button-raised">Browse Catalog</a>
	            </div>
	        </div>
		<?php } ?>
	</div>
</div>