<?php 
if ( ! defined( 'ABSPATH' ) )
	exit;

	global $dtcwm_settings_config, $dtcwm_device_detect;

    // new arrivals products
    $new_args = array( 
        'post_type' => 'product', 
        'posts_per_page' => 6,
        'orderby' =>'date',
        'order' => 'DESC'
    );
    $new_loop = new WP_Query( $new_args );


    // Best Sellers
    $best_sellers_args = array(
        'post_type' => 'product', 
        'meta_key' => 'total_sales',
        'posts_per_page' => 8,
        'orderby' =>'meta_value_num',
        'order' => 'DESC'
    );
    $best_sellers_loop = new WP_Query( $best_sellers_args );
?>
<div data-page="home" id="page-home" class="page">

	<div class="navbar">
		<div class="navbar-inner navbar-shadow">

		    <div class="left">
		        <?php if ( true == dtcwm_nav_layout_check( 'sidepanel' ) ) { ?>
		        <a href="#" class="link icon-only open-panel">
		            <i class="icon {{deviceIos ? 'wm-ios-menu' : 'wm-android-menu'}}"></i>
		        </a>
		        <?php } ?>
		    </div>

		    <?php if ( $dtcwm_settings_config['site_logo'] ) { ?>
		    <div class="center sliding logo"><img src="<?= $dtcwm_settings_config['site_logo']; ?>"></div>
		    <?php } else { ?>
		    <div class="center sliding"><span class="title"><?= $dtcwm_settings_config['site_title']; ?></span></div>
		    <?php } ?>

		    <div class="right">
		        <?php if ( $dtcwm_device_detect->isAndroidOS() ) { ?>
		        <a ng-if="deviceAndroid" href="#search" class="link icon-only">
		            <i class="icon {{deviceIos ? 'wm-ios-search' : 'wm-android-search'}}"></i>
		        </a>
		        <?php } ?>

		        <a href="#cart" class="link icon-only">
		            <span class="cart-badge" ng-bind="cartTotalShow"></span>
		            <i class="icon {{deviceIos ? 'wm-ios-cart' : 'wm-android-cart'}}"></i>
		        </a>
		    </div>
		</div>
	</div>
    
    <?php get_template_part( 'layouts/bottombar', $dtcwm_settings_config['layouts']['bottombar'] ); ?>
    
	<div class="page-content">
	
		<div class="swiper-container swiper-init" data-space-between="10" data-auto-height="true" data-pagination=".swiper-pagination">
		    <div class="swiper-wrapper">

		    	<?php foreach ( $dtcwm_settings_config['home_slider'] as $item => $value ) { 
		    		if ( $value != '' ) { 
		    	?>
				<div class="swiper-slide">
	    			<img class="img-responsive" src="<?= $value; ?>">
	    		</div>
		    	<?php 
		    		}
		    	} 
		    	?>

		    </div>
		    <div class="swiper-pagination"></div>
		</div>

		<?php if ( $best_sellers_loop->have_posts() ) { ?>
		<div class="title-intro content-block-title">Special Offers <span class="pull-right"><a href="#catalog">See All</a></span></div>
		<div class="product-hscroll swiper-container swiper-init" data-auto-height="true" data-free-mode="true" data-slides-per-view="auto">
			<div class="swiper-wrapper">

				<?php while ( $best_sellers_loop->have_posts() ) : $best_sellers_loop->the_post(); global $product; ?>

				<div class="swiper-slide">
					<div class="card">
						<div class="card-content">
						<a href="#view-product" ng-click="$storage.productView = <?= $product->id; ?>">
							<?php 
							if ( has_post_thumbnail($best_sellers_loop->post->ID) ) {
								echo get_the_post_thumbnail( $best_sellers_loop->post->ID, 'shop_catalog' ); 
							} else {
								echo '<img src="'.woocommerce_placeholder_img_src().'"/>'; 
							} ?>
							<div class="overlay">
								<div class="title"><?= the_title(); ?></div>
								<div class="price"><?= wc_price( $product->get_price() ); ?>
								<?php if ( get_option( 'woocommerce_enable_review_rating' ) != 'no' ) { ?>
                                    <div class="star-rating pull-right">
                                        <span style="width:<?= ( ( $product->get_average_rating() / 5 ) * 100 ); ?>%"></span>
                                    </div>
                                <?php } ?>
								</div>
							</div>
						</a>
						</div>
					</div>	
				</div>
				<?php endwhile; ?>

			</div>
		</div>
		<?php } wp_reset_postdata(); ?>

		<?php if ( $new_loop->have_posts() ) { ?>
		<div class="title-intro content-block-title">Latest Items <span class="pull-right"><a href="#catalog">See All</a></span></div>
		<div class="product-grid">
			<div class="row">
				<?php while ( $new_loop->have_posts() ) : $new_loop->the_post(); global $product; ?>
				<div class="col-50">
					<div class="card">
						<div class="card-content">
							<a href="#view-product" ng-click="$storage.productView = <?= $product->id; ?>">
							<?php 
							if ( has_post_thumbnail($new_loop->post->ID) ) {
								echo get_the_post_thumbnail( $new_loop->post->ID, 'shop_catalog' ); 
							} else {
								echo '<img src="'.woocommerce_placeholder_img_src().'"/>'; 
							} ?>
							</a>
						</div>
						<div class="footer">
							<div class="title"><?= the_title(); ?></div>
							<div class="price"><?= wc_price( $product->get_price() ); ?>
							<?php if ( get_option( 'woocommerce_enable_review_rating' ) != 'no' ) { ?>
                                <div class="star-rating pull-right">
                                    <span style="width:<?= ( ( $product->get_average_rating() / 5 ) * 100 ); ?>%"></span>
                                </div>
                            <?php } ?>
							</div>
						</div>
					</div>
				</div>
				<?php endwhile; ?>
			</div>
		</div>
		<?php } wp_reset_postdata(); ?>
		
	</div>
</div>