<?php 
if ( ! defined( 'ABSPATH' ) )
    exit;

global $dtcwm_settings_config; 
?>
<div ng-controller="SearchCtrl" data-page="search" id="page-search" class="page cached">

	<div class="navbar navbar-shadow">
        <form data-custom-search="true" class="searchbar searchbar-init">
            <a href="#" class="back link icon-only">
                <i class="icon {{deviceIos ? 'wm-ios-arrow-left' : 'wm-android-arrow-left'}}"></i>
            </a>
            <div class="searchbar-input">
                <input type="search" placeholder="I'm shopping for..." ng-model="query" ng-enter="search()">
                <a href="#" class="searchbar-clear"></a>
            </div>
        </form>
    </div>

    <?php get_template_part( 'layouts/bottombar', $dtcwm_settings_config['layouts']['bottombar'] ); ?>

	<div class="page-content infinite-scroll">
		<?php 
			get_template_part( 'contents/content', 'preloader' );
			get_template_part( 'contents/content', 'error_response' );
		?>

        <div class="blank-state empty-msg">
            <div class="content-block text-center">
                <div class="empty-icon">
                	<i class="icon wm-empty-arrow-up"></i>
                </div>
                <h2>Search for products</h2>
                <p>Click on the search bar above to start your search.</p>
            </div>
        </div>

        <div class="hidden not-found">
            <div class="content-block text-center">
                <div class="empty-icon">
                	<i class="icon wm-empty-info"></i>
                </div>
                <h2>No results were found</h2>
                <p>We were unable to find any results matching your search terms. Please try your search again.</p>
            </div>
        </div>

		<?php 
			get_template_part( 'contents/content', 'product_listing' );
			get_template_part( 'contents/content', 'infinite_scroll' ); 
		?>
	</div>
</div>