<?php 
if ( ! defined( 'ABSPATH' ) ) 
    exit;

if ( false == dtcwm_nav_layout_check( 'sidepanel' ) )
    return;
?>

<div class="panel-overlay"></div>
<div class="panel panel-left {{deviceAndroid ? 'panel-cover' : 'panel-reveal'}}">

    <div ng-class="{'theme-color-bg':deviceAndroid}" class="panel-header">
        <a class="close-panel external" href="<?= get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>">
            <div class="avatar theme-color-text">
                <i class="icon {{deviceIos ? 'wm-ios-contact' : 'wm-android-contact'}}"></i>
            </div>
            <div class="info theme-color-text">
                <h3>Welcome</h3>
                <?php if ( is_user_logged_in() ) { 
                    $user = wp_get_current_user();
                ?>
                    <span><?= $user->user_firstname ; ?> <?= $user->user_lastname; ?></span>
                <?php } else { ?>
                    <span>Login or sign up</span>
                <?php } ?>
            </div>
        </a>
    </div>

    <div class="content-block-title">Menu</div>
    <div class="list-block">
        <ul>
            <li>
                <a href="#home" class="item-link item-content close-panel">
                    <div class="item-media">
                        <i class="icon {{deviceIos ? 'wm-ios-home' : 'wm-android-home'}}"></i>
                    </div>
                    <div class="item-inner">
                        <div class="item-title">Home</div>
                    </div>
                </a>
            </li>
            <li>
                <a href="<?= get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" class="item-link item-content external close-panel">
                    <div class="item-media">
                        <i class="icon {{deviceIos ? 'wm-ios-person' : 'wm-android-person'}}"></i>
                    </div>
                    <div class="item-inner">
                        <div class="item-title">My Account</div>
                    </div>
                </a>
            </li>
            <li>
                <a href="#category" class="item-link item-content close-panel">
                    <div class="item-media">
                        <i class="icon {{deviceIos ? 'wm-ios-pricetags' : 'wm-android-pricetags'}}"></i>
                    </div>
                    <div class="item-inner">
                        <div class="item-title">Categories</div>
                    </div>
                </a>
            </li>
            <li>
                <a href="#search" class="item-link item-content close-panel">
                    <div class="item-media">
                        <i class="icon {{deviceIos ? 'wm-ios-search' : 'wm-android-search'}}"></i>
                    </div>
                    <div class="item-inner">
                        <div class="item-title">Search</div>
                    </div>
                </a>
            </li>
            <li>
                <a href="#cart" class="item-link item-content close-panel">
                    <div class="item-media">
                        <i class="icon {{deviceIos ? 'wm-ios-cart' : 'wm-android-cart'}}"></i>
                    </div>
                    <div class="item-inner">
                        <div class="item-title">My Cart</div>
                    </div>
                </a>
            </li>
            <li>
                <a ng-if="$storage.cartTotal" href="<?php echo esc_url( wc_get_checkout_url() ) ;?>" class="item-link item-content external close-panel">
                    <div class="item-media">
                        <i class="icon {{deviceIos ? 'wm-ios-exit' : 'wm-android-exit'}}"></i>
                    </div>
                    <div class="item-inner">
                        <div class="item-title">Checkout</div>
                    </div>
                </a>
            </li>
        </ul>
    </div>

	<div class="panel-footer">
		<div class="copyright">&copy; <?= date('Y') ;?> <?= get_bloginfo('name'); ?></div>
	</div>

</div>