<?php
/**
 * Pay for order form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-pay.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see      https://docs.woocommerce.com/document/template-structure/
 * @author   WooThemes
 * @package  WooCommerce/Templates
 * @version  2.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<?php global $dtcwm_settings_config, $dtcwm_device_detect; ?>

<div id="page-order-pay" class="page">

	<div class="navbar">
		<div class="navbar-inner navbar-shadow">
		    <div class="left">
		        <a href="<?php echo esc_url( wc_get_account_endpoint_url( 'orders' ) ); ?>" class="external link icon-only"><i class="icon {{deviceIos ? 'wm-ios-arrow-left' : 'wm-android-arrow-left'}}"></i></a>
		    </div>

		    <div class="center sliding"><span class="title">Pay for Order</span></div>

		    <div class="right">
		        <?php if ( $dtcwm_device_detect->isAndroidOS() ) { ?>
		        <a ng-if="deviceAndroid" href="#search" class="link icon-only">
		            <i class="icon {{deviceIos ? 'wm-ios-search' : 'wm-android-search'}}"></i>
		        </a>
		        <?php } ?>

		        <a href="#cart" class="link icon-only">
		            <span class="cart-badge" ng-bind="cartTotalShow"></span>
		            <i class="icon {{deviceIos ? 'wm-ios-cart' : 'wm-android-cart'}}"></i>
		        </a>
		    </div>
		</div>
	</div>
    
    <?php get_template_part( 'layouts/bottombar', $dtcwm_settings_config['layouts']['bottombar'] ); ?>
    
	<div class="page-content">

		<form action="" id="order_review" method="post">

			<div class="content-block-title">Order Details</div>
			<div class="content-block">
			    <div class="content-block-inner bg-white">
					<table class="list-table order-details">
						<tbody>
							<?php if ( sizeof( $order->get_items() ) > 0 ) : ?>
								<?php foreach ( $order->get_items() as $item_id => $item ) : ?>
									<?php
										if ( ! apply_filters( 'woocommerce_order_item_visible', true, $item ) ) {
											continue;
										}
									?>
									<tr class="<?php echo esc_attr( apply_filters( 'woocommerce_order_item_class', 'order_item', $item, $order ) ); ?>">
										<td class="product-name">
											<?php
												echo apply_filters( 'woocommerce_order_item_name', esc_html( $item['name'] ), $item, false );

												do_action( 'woocommerce_order_item_meta_start', $item_id, $item, $order );
												$order->display_item_meta( $item );
												do_action( 'woocommerce_order_item_meta_end', $item_id, $item, $order );
											?>
										</td>
										<td class="product-quantity"><?php echo apply_filters( 'woocommerce_order_item_quantity_html', ' <strong class="product-quantity">' . sprintf( '&times; %s', esc_html( $item['qty'] ) ) . '</strong>', $item ); ?></td>
										<td class="product-subtotal"><?php echo $order->get_formatted_line_subtotal( $item ); ?></td>
									</tr>
								<?php endforeach; ?>
							<?php endif; ?>
						</tbody>
						<tfoot>
							<?php if ( $totals = $order->get_order_item_totals() ) : ?>
								<?php foreach ( $totals as $total ) : ?>
									<tr>
										<th scope="row" colspan="2"><?php echo $total['label']; ?></th>
										<td class="product-total"><?php echo $total['value']; ?></td>
									</tr>
								<?php endforeach; ?>
							<?php endif; ?>
						</tfoot>
					</table>
				</div>
			</div>

			<div class="content-block-title">Payment Method</div>
			<?php if ( $order->needs_payment() ) : ?>
				<div class="bg-white payment-radio list-block media-list">
				<ul>
					<?php
						if ( ! empty( $available_gateways ) ) {
							foreach ( $available_gateways as $gateway ) { ?>
							<li>
                                <label class="label-radio item-content">
                                    <input id="payment_method_<?php echo $gateway->id; ?>" type="radio" class="input-radio" name="payment_method" value="<?php echo esc_attr( $gateway->id ); ?>" <?php checked( $gateway->chosen, true ); ?>" />
                                    <div class="item-media">
                                        <i class="icon icon-form-radio"></i>
                                    </div>
                                    <div class="item-inner">
                                        <div class="item-title-row">
                                            <div class="item-title"><?php echo $gateway->get_title(); ?></div>
                                        </div>
                                        <div class="item-text"><?php $gateway->payment_fields(); ?></div>
                                    </div>
                                </label>
                            </li>

							<?php }
						} else {
							echo apply_filters( 'woocommerce_no_available_payment_methods_message', __( 'Sorry, it seems that there are no available payment methods for your location. Please contact us if you require assistance or wish to make alternate arrangements.', 'woocommerce' ) );
						}
					?>
				</ul>
				</div>
			<?php endif; ?>

			<input type="hidden" name="woocommerce_pay" value="1" />

			<div class="content-block">
				<?php echo apply_filters( 'woocommerce_pay_order_button_html', '<input type="submit" class="button button-big button-fill button-raised" id="place_order" value="' . esc_attr( $order_button_text ) . '" data-value="' . esc_attr( $order_button_text ) . '" />' ); ?>
			</div>
					
			<?php wp_nonce_field( 'woocommerce-pay' ); ?>
		
		</form>
	
	</div>
</div>