<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-account-dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<?php global $dtcwm_settings_config, $dtcwm_device_detect; ?>

<div data-page="account" id="page-account" class="page">

	<div class="navbar">
		<div class="navbar-inner navbar-shadow">
		    <div class="left">
		        <?php if ( true == dtcwm_nav_layout_check( 'sidepanel' ) ) { ?>
		        <a href="#" class="link icon-only open-panel">
		            <i class="icon {{deviceIos ? 'wm-ios-menu' : 'wm-android-menu'}}"></i>
		        </a>
		        <?php } ?>
		    </div>

		    <div class="center sliding"><span class="title">My Account</span></div>

		    <div class="right">
		        <?php if ( $dtcwm_device_detect->isAndroidOS() ) { ?>
		        <a ng-if="deviceAndroid" href="#search" class="link icon-only">
		            <i class="icon {{deviceIos ? 'wm-ios-search' : 'wm-android-search'}}"></i>
		        </a>
		        <?php } ?>

		        <a href="#cart" class="link icon-only">
		            <span class="cart-badge" ng-bind="cartTotalShow"></span>
		            <i class="icon {{deviceIos ? 'wm-ios-cart' : 'wm-android-cart'}}"></i>
		        </a>
		    </div>
		</div>
	</div>
    
    <?php get_template_part( 'layouts/bottombar', $dtcwm_settings_config['layouts']['bottombar'] ); ?>
    
	<div class="page-content">

		<div class="content-block-title">Hello <?= $current_user->display_name; ?> <a ng-click="authLogout()" href="<?php echo esc_url( wc_get_account_endpoint_url( 'customer-logout' ) ); ?>" class="pull-right external">Logout</a></div>
		<div class="content-block">
			<div class="content-block-inner bg-white">
				<p>From your account dashboard you can view your recent orders, manage your shipping and billing addresses and edit your password and account details.</p>
			</div>
		</div>

		<div class="content-block grid-block">
		      <div class="content-block-inner bg-white">

				<div class="row">
					<div class="col-50">
						<a href="<?php echo esc_url( wc_get_account_endpoint_url( 'orders' ) ); ?>" class="external">
							<i class="icon {{deviceIos ? 'wm-ios-order' : 'wm-android-order'}}"></i>
							<span>Orders</span>
						</a>
					</div>
					<div class="col-50">
						<a href="<?php echo esc_url( wc_get_account_endpoint_url( 'downloads' ) ); ?>" class="external">
							<i class="icon {{deviceIos ? 'wm-ios-download' : 'wm-android-download'}}"></i>
							<span>Downloads</span>
						</a>
					</div>	
				</div>

				<div class="row">
					<div class="col-50">
						<a href="<?php echo esc_url( wc_get_account_endpoint_url( 'edit-address' ) ); ?>" class="external">
							<i class="icon {{deviceIos ? 'wm-ios-copy' : 'wm-android-copy'}}"></i>
							<span>Addresses</span>
						</a>
					</div>
					<div class="col-50">
						<a href="<?php echo esc_url( wc_get_account_endpoint_url( 'edit-account' ) ); ?>" class="external">
							<i class="icon {{deviceIos ? 'wm-ios-people' : 'wm-android-people'}}"></i>
							<span>Acount Detials</span>
						</a>
					</div>	
				</div>

		    </div>
		</div>

	</div>
</div>