<?php
/**
 * Edit address form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-edit-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $dtcwm_settings_config, $dtcwm_device_detect;
?>

<div id="page-address" class="page">

	<div class="navbar">
		<div class="navbar-inner navbar-shadow">
		    <div class="left">
		        <a href="<?= get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" class="external link icon-only"><i class="icon {{deviceIos ? 'wm-ios-arrow-left' : 'wm-android-arrow-left'}}"></i></a>
		    </div>

		    <div class="center sliding"><span class="title">Addresses</span></div>

		    <div class="right">
		        <?php if ( $dtcwm_device_detect->isAndroidOS() ) { ?>
		        <a ng-if="deviceAndroid" href="#search" class="link icon-only">
		            <i class="icon {{deviceIos ? 'wm-ios-search' : 'wm-android-search'}}"></i>
		        </a>
		        <?php } ?>

		        <a href="#cart" class="link icon-only">
		            <span class="cart-badge" ng-bind="cartTotalShow"></span>
		            <i class="icon {{deviceIos ? 'wm-ios-cart' : 'wm-android-cart'}}"></i>
		        </a>
		    </div>
		</div>
	</div>
    
    <?php get_template_part( 'layouts/bottombar', $dtcwm_settings_config['layouts']['bottombar'] ); ?>
    
	<div class="page-content">

		<?php
		$page_title = ( $load_address === 'billing' ) ? __( 'Billing Address', 'woocommerce' ) : __( 'Shipping Address', 'woocommerce' );
		?>

		<?php if ( ! $load_address ) : ?>
			<?php wc_get_template( 'myaccount/my-address.php' ); ?>
		<?php else : ?>

			<form action="" method="post" class="hide-keypad">
				<div class="content-block-title"><?php echo apply_filters( 'woocommerce_my_account_edit_address_title', $page_title ); ?></div>
				<div class="content-block">
	                <div class="content-block-inner bg-white custom-inputs pb-0">
                	<?php 
					foreach ( $address as $key => $field ) :
						woocommerce_form_field( $key, $field, ! empty( $_POST[ $key ] ) ? wc_clean( $_POST[ $key ] ) : $field['value'] );
					endforeach;
					?>
					<div class="clearfix"></div>
					</div>
				</div>

				<div class="content-block">
					<input type="submit" class="button button-big button-fill button-round button-raised external" name="save_address" value="<?php esc_attr_e( 'Save Address', 'woocommerce' ); ?>" />
					<?php wp_nonce_field( 'woocommerce-edit_address' ); ?>
					<input type="hidden" name="action" value="edit_address" />
				</div>
			</form>

		<?php endif; ?>

	</div>
</div>
