<?php
/**
 * View Order
 *
 * Shows the details of a particular order on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/view-order.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $dtcwm_settings_config, $dtcwm_device_detect;
?>

<div id="page-view-order" class="page">

	<div class="navbar">
		<div class="navbar-inner navbar-shadow">
		    <div class="left">
		        <a href="<?php echo esc_url( wc_get_account_endpoint_url( 'orders' ) ); ?>" class="external link icon-only"><i class="icon {{deviceIos ? 'wm-ios-arrow-left' : 'wm-android-arrow-left'}}"></i></a>
		    </div>

		    <div class="center sliding"><span class="title">Order Details</span></div>

		    <div class="right">
		        <?php if ( $dtcwm_device_detect->isAndroidOS() ) { ?>
		        <a ng-if="deviceAndroid" href="#search" class="link icon-only">
		            <i class="icon {{deviceIos ? 'wm-ios-search' : 'wm-android-search'}}"></i>
		        </a>
		        <?php } ?>

		        <a href="#cart" class="link icon-only">
		            <span class="cart-badge" ng-bind="cartTotalShow"></span>
		            <i class="icon {{deviceIos ? 'wm-ios-cart' : 'wm-android-cart'}}"></i>
		        </a>
		    </div>
		</div>
	</div>
    
    <?php get_template_part( 'layouts/bottombar', $dtcwm_settings_config['layouts']['bottombar'] ); ?>
    
	<div class="page-content">

		<div class="card">
		    <div class="card-content">
		        <div class="card-content-inner">
					<?php
						printf(
							__( 'Order #%1$s was placed on %2$s and is currently %3$s.', 'woocommerce' ),
							'<mark class="order-number">' . $order->get_order_number() . '</mark>',
							'<mark class="order-date">' . date_i18n( get_option( 'date_format' ), strtotime( $order->order_date ) ) . '</mark>',
							'<mark class="order-status">' . wc_get_order_status_name( $order->get_status() ) . '</mark>'
						);
					?>        	
		        </div>
		    </div>
		</div> 

		<?php if ( $notes = $order->get_customer_order_notes() ) : ?>
			<div class="content-block-title"><?php _e( 'Order Updates', 'woocommerce' ); ?></div>
			<div class="content-block mb-0">
				<div class="content-block-inner bg-white">

					<ol>
						<?php foreach ( $notes as $note ) : ?>
						<li>
							<strong><?php echo date_i18n( __( 'l jS \o\f F Y, h:ia', 'woocommerce' ), strtotime( $note->comment_date ) ); ?></strong>
							<p><?php echo wpautop( wptexturize( $note->comment_content ) ); ?></p>
						</li>
						<?php endforeach; ?>
					</ol>

				</div>
			</div>
		<?php endif; ?>

		<?php
		$order = wc_get_order( $order_id );

		$show_purchase_note    = $order->has_status( apply_filters( 'woocommerce_purchase_note_order_statuses', array( 'completed', 'processing' ) ) );
		$show_customer_details = is_user_logged_in() && $order->get_user_id() === get_current_user_id();
		?>
		
		<div class="content-block-title"><?php _e( 'Order Details', 'woocommerce' ); ?></div>
		<div class="content-block mb-0">
				<div class="content-block-inner bg-white">
				<table class="list-table order-details">
					<tbody>
						<?php
							foreach( $order->get_items() as $item_id => $item ) {
								$product = apply_filters( 'woocommerce_order_item_product', $order->get_product_from_item( $item ), $item );

								wc_get_template( 'order/order-details-item.php', array(
									'order'			     => $order,
									'item_id'		     => $item_id,
									'item'			     => $item,
									'show_purchase_note' => $show_purchase_note,
									'purchase_note'	     => $product ? get_post_meta( $product->id, '_purchase_note', true ) : '',
									'product'	         => $product,
								) );
							}
						?>
						<?php do_action( 'woocommerce_order_items_table', $order ); ?>
					</tbody>
					<tfoot>
						<?php
							foreach ( $order->get_order_item_totals() as $key => $total ) {
								?>
								<tr>
									<th scope="row"><?php echo $total['label']; ?></th>
									<td><?php echo $total['value']; ?></td>
								</tr>
								<?php
							}
						?>
					</tfoot>
				</table>
			</div>
		</div>

		<?php if ( $show_customer_details ) : ?>
			<?php wc_get_template( 'order/order-details-customer.php', array( 'order' =>  $order ) ); ?>
		<?php endif; ?>
		
	</div>
</div>